/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.download.jobenumerators;

import java.awt.Point;
import java.util.Enumeration;
import mobac.program.JobDispatcher;
import mobac.program.download.DownloadJob;
import mobac.program.interfaces.DownloadJobListener;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.TileFilter;
import mobac.program.model.Map;
import mobac.utilities.tar.TarIndexedArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadJobEnumerator
implements Enumeration<JobDispatcher.Job> {
    protected final TileFilter tileFilter;
    protected final DownloadJobListener listener;
    protected final int xMin;
    protected final int xMax;
    protected final int yMax;
    protected final int zoom;
    protected final MapSource mapSource;
    protected final TarIndexedArchive tileArchive;
    protected int x;
    protected int y;
    protected JobDispatcher.Job nextJob;

    public DownloadJobEnumerator(Map map, MapSource mapSource, TarIndexedArchive tileArchive, DownloadJobListener listener) {
        this.tileFilter = map.getTileFilter();
        this.listener = listener;
        Point minCoord = map.getMinTileCoordinate();
        Point maxCoord = map.getMaxTileCoordinate();
        int tileSize = map.getMapSource().getMapSpace().getTileSize();
        this.xMin = minCoord.x / tileSize;
        this.xMax = maxCoord.x / tileSize;
        int yMin = minCoord.y / tileSize;
        this.yMax = maxCoord.y / tileSize;
        this.zoom = map.getZoom();
        this.tileArchive = tileArchive;
        this.mapSource = mapSource;
        this.y = yMin;
        this.x = this.xMin;
        this.nextJob = new DownloadJob(mapSource, this.x, this.y, this.zoom, tileArchive, listener);
        if (!this.tileFilter.testTile(this.x, this.y, this.zoom, mapSource)) {
            this.nextElement();
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextJob != null;
    }

    @Override
    public JobDispatcher.Job nextElement() {
        JobDispatcher.Job job = this.nextJob;
        boolean filter = false;
        do {
            ++this.x;
            if (this.x <= this.xMax) continue;
            ++this.y;
            this.x = this.xMin;
            if (this.y <= this.yMax) continue;
            this.nextJob = null;
            return job;
        } while (!(filter = this.tileFilter.testTile(this.x, this.y, this.zoom, this.mapSource)));
        this.nextJob = new DownloadJob(this.mapSource, this.x, this.y, this.zoom, this.tileArchive, this.listener);
        return job;
    }
}

