/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import mobac.program.atlascreators.tileprovider.FilterTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageType;
import mobac.program.tiledatawriter.TileImagePngDataWriter;
import mobac.utilities.Utilities;

public class PngTileProvider
extends FilterTileProvider {
    final TileImageDataWriter writer = new TileImagePngDataWriter();

    public PngTileProvider(TileProvider tileProvider) {
        super(tileProvider);
        this.writer.initialize();
    }

    public byte[] getTileData(int x, int y) throws IOException {
        byte[] data;
        if (!this.tileProvider.preferTileImageUsage() && Utilities.getImageType(data = super.getTileData(x, y)) == TileImageType.PNG) {
            return data;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(32000);
        BufferedImage image = this.getTileImage(x, y);
        if (image == null) {
            return null;
        }
        this.writer.processImage(image, buffer);
        return buffer.toByteArray();
    }

    public boolean preferTileImageUsage() {
        return true;
    }
}

