/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.TileImageType;
import mobac.utilities.tar.TarIndex;
import org.apache.log4j.Logger;

public class DownloadedTileProvider
implements TileProvider {
    private static final Logger log = Logger.getLogger(DownloadedTileProvider.class);
    protected final TarIndex tarIndex;
    protected final MapInterface map;
    protected final TileImageType mapTileType;

    public DownloadedTileProvider(TarIndex tarIndex, MapInterface map) {
        this.tarIndex = tarIndex;
        this.map = map;
        this.mapTileType = map.getMapSource().getTileImageType();
    }

    public byte[] getTileData(int x, int y) throws IOException {
        log.trace("Reading tile x=" + x + " y=" + y);
        return this.tarIndex.getEntryContent(String.format("x%dy%d", x, y));
    }

    public BufferedImage getTileImage(int x, int y) throws IOException {
        byte[] unconvertedTileData = this.getTileData(x, y);
        if (unconvertedTileData == null) {
            return null;
        }
        return ImageIO.read(new ByteArrayInputStream(unconvertedTileData));
    }

    public boolean preferTileImageUsage() {
        return false;
    }
}

