/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.program.atlascreators.tileprovider.FilterTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageFormat;

public class ConvertedRawTileProvider
extends FilterTileProvider {
    private TileImageDataWriter writer;

    public ConvertedRawTileProvider(TileProvider tileProvider, TileImageFormat tileImageFormat) {
        super(tileProvider);
        this.writer = tileImageFormat.getDataWriter();
        this.writer.initialize();
        ImageIO.setUseCache(false);
    }

    public byte[] getTileData(int x, int y) throws IOException {
        BufferedImage image = this.getTileImage(x, y);
        if (image == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(32000);
        this.writer.processImage(image, buffer);
        return buffer.toByteArray();
    }

    public boolean preferTileImageUsage() {
        return true;
    }
}

