/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.rmp;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import mobac.exceptions.MapCreationException;
import mobac.program.atlascreators.impl.rmp.BoundingRect;
import mobac.program.atlascreators.impl.rmp.MultiImage;
import mobac.program.atlascreators.impl.rmp.RmpTools;
import mobac.program.interfaces.TileImageDataWriter;

public class Tiledata {
    private final TileImageDataWriter writer;
    public int posx;
    public int posy;
    public int totalOffset;
    public MultiImage si;
    public BoundingRect rect;
    private int dataSize = 0;

    public Tiledata(TileImageDataWriter writer) {
        this.writer = writer;
    }

    public int getTileDataSize() {
        return this.dataSize;
    }

    public void writeTileData(OutputStream out) throws IOException {
        try {
            BufferedImage image = this.si.getSubImage(this.rect, 256, 256);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(16384);
            this.writer.processImage(image, bout);
            byte[] data = bout.toByteArray();
            this.dataSize = data.length;
            RmpTools.writeValue(out, this.dataSize, 4);
            out.write(data);
        }
        catch (MapCreationException e) {
            throw new IOException(e.getCause());
        }
    }
}

