/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageFormat;
import mobac.program.model.TileImageParameters;
import mobac.program.model.TileImageType;
import mobac.program.tiledatawriter.TileImageJpegDataWriter;
import mobac.utilities.Utilities;
import org.apache.log4j.Level;

@AtlasCreatorName(value="TwoNav (RMAP)")
@SupportedParameters(names={TileImageParameters.Name.format})
public class TwoNavRMAP
extends AtlasCreator {
    private RmapFile rmapFile = null;

    public TwoNavRMAP() {
        this.log.setLevel(Level.TRACE);
    }

    protected void testAtlas() throws AtlasTestException {
        for (LayerInterface layer : this.atlas) {
            MapInterface map0 = layer.getMap(0);
            MapSpace mapSpace0 = map0.getMapSource().getMapSpace();
            double longitudeMin = mapSpace0.cXToLon(map0.getMinTileCoordinate().x, map0.getZoom());
            double longitudeMax = mapSpace0.cXToLon(map0.getMaxTileCoordinate().x + 1, map0.getZoom());
            double latitudeMin = mapSpace0.cYToLat(map0.getMaxTileCoordinate().y + 1, map0.getZoom());
            double latitudeMax = mapSpace0.cYToLat(map0.getMinTileCoordinate().y, map0.getZoom());
            for (int n = 1; n < layer.getMapCount(); ++n) {
                MapInterface mapN = layer.getMap(n);
                MapSpace mapSpaceN = mapN.getMapSource().getMapSpace();
                double longitudeMinN = mapSpaceN.cXToLon(mapN.getMinTileCoordinate().x, mapN.getZoom());
                double longitudeMaxN = mapSpaceN.cXToLon(mapN.getMaxTileCoordinate().x + 1, mapN.getZoom());
                double latitudeMinN = mapSpaceN.cYToLat(mapN.getMaxTileCoordinate().y + 1, mapN.getZoom());
                double latitudeMaxN = mapSpaceN.cYToLat(mapN.getMinTileCoordinate().y, mapN.getZoom());
                if (longitudeMin != longitudeMinN || longitudeMax != longitudeMaxN || latitudeMin != latitudeMinN || latitudeMax != latitudeMaxN) {
                    throw new AtlasTestException("All maps in one layer have to cover the same area!\nUse grid zoom on the lowest zoom level to get an acceptable result.");
                }
                for (int m = 0; m < layer.getMapCount(); ++m) {
                    if (mapN.getZoom() != layer.getMap(m).getZoom() || m == n) continue;
                    throw new AtlasTestException("Several maps with the same zoom level within the same layer are not supported!");
                }
            }
        }
    }

    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        return mapSpace instanceof MercatorPower2MapSpace && MapSpace.ProjectionCategory.SPHERE.equals((Object)mapSpace.getProjectionCategory());
    }

    public void initLayerCreation(LayerInterface layer) throws IOException {
        int n;
        if (this.rmapFile != null) {
            throw new RuntimeException("Layer mismatch - last layer has not been finished correctly!");
        }
        super.initLayerCreation(layer);
        this.rmapFile = new RmapFile(new File(this.atlasDir, layer.getName() + ".rmap"));
        int DefaultMap = 0;
        this.rmapFile.width = 0;
        this.rmapFile.height = 0;
        for (int n2 = 0; n2 < layer.getMapCount(); ++n2) {
            int width = layer.getMap((int)n2).getMaxTileCoordinate().x - layer.getMap((int)n2).getMinTileCoordinate().x + 1;
            int height = layer.getMap((int)n2).getMaxTileCoordinate().y - layer.getMap((int)n2).getMinTileCoordinate().y + 1;
            if (width <= this.rmapFile.width && height <= this.rmapFile.height) continue;
            this.rmapFile.width = width;
            this.rmapFile.height = height;
            DefaultMap = n2;
        }
        this.log.trace("rmap width  = " + this.rmapFile.width);
        this.log.trace("rmap height = " + this.rmapFile.height);
        this.rmapFile.tileWidth = layer.getMap((int)DefaultMap).getTileSize().width;
        this.rmapFile.tileHeight = layer.getMap((int)DefaultMap).getTileSize().height;
        this.log.trace("rmap tileWidth  = " + this.rmapFile.tileWidth);
        this.log.trace("rmap tileHeight = " + this.rmapFile.tileHeight);
        MapSpace mapSpace = layer.getMap(DefaultMap).getMapSource().getMapSpace();
        this.rmapFile.longitudeMin = mapSpace.cXToLon(layer.getMap((int)DefaultMap).getMinTileCoordinate().x, layer.getMap(DefaultMap).getZoom());
        this.rmapFile.longitudeMax = mapSpace.cXToLon(layer.getMap((int)DefaultMap).getMaxTileCoordinate().x, layer.getMap(DefaultMap).getZoom());
        this.rmapFile.latitudeMin = mapSpace.cYToLat(layer.getMap((int)DefaultMap).getMaxTileCoordinate().y, layer.getMap(DefaultMap).getZoom());
        this.rmapFile.latitudeMax = mapSpace.cYToLat(layer.getMap((int)DefaultMap).getMinTileCoordinate().y, layer.getMap(DefaultMap).getZoom());
        this.log.trace("rmap longitudeMin = " + this.rmapFile.longitudeMin);
        this.log.trace("rmap longitudeMax = " + this.rmapFile.longitudeMax);
        this.log.trace("rmap latitudeMin = " + this.rmapFile.latitudeMin);
        this.log.trace("rmap latitudeMax = " + this.rmapFile.latitudeMax);
        double width = this.rmapFile.width;
        double height = this.rmapFile.height;
        int count = 1;
        while (width >= 256.0 || height >= 256.0) {
            width = Math.ceil(width / 2.0);
            height = Math.ceil(height / 2.0);
            ++count;
        }
        this.log.trace("rmap zoomLevels count = " + count);
        RmapFile.access$1402(this.rmapFile, new ZoomLevel[count]);
        width = this.rmapFile.width;
        height = this.rmapFile.height;
        for (n = 0; n < this.rmapFile.zoomLevels.length; ++n) {
            ((RmapFile)this.rmapFile).zoomLevels[n] = new ZoomLevel();
            this.rmapFile.zoomLevels[n].index = n;
            this.rmapFile.zoomLevels[n].width = (int)Math.round(width);
            this.rmapFile.zoomLevels[n].height = (int)Math.round(height);
            this.rmapFile.zoomLevels[n].xTiles = (int)Math.ceil((double)this.rmapFile.zoomLevels[n].width / (double)this.rmapFile.tileWidth);
            this.rmapFile.zoomLevels[n].yTiles = (int)Math.ceil((double)this.rmapFile.zoomLevels[n].height / (double)this.rmapFile.tileHeight);
            ZoomLevel.access$2102(this.rmapFile.zoomLevels[n], new long[this.rmapFile.zoomLevels[n].xTiles][this.rmapFile.zoomLevels[n].yTiles]);
            this.rmapFile.zoomLevels[n].zoom = layer.getMap(DefaultMap).getZoom() - n;
            this.rmapFile.zoomLevels[n].dl = false;
            for (int m = 0; m < layer.getMapCount(); ++m) {
                if (this.rmapFile.zoomLevels[n].zoom != layer.getMap(m).getZoom()) continue;
                this.rmapFile.zoomLevels[n].dl = true;
            }
            width = Math.ceil(width / 2.0);
            height = Math.ceil(height / 2.0);
        }
        for (n = 0; n < this.rmapFile.zoomLevels.length; ++n) {
            this.log.trace(String.format("zoomLevels[%d] zoom=%d %dx%d pixels, %dx%d tiles %s", this.rmapFile.zoomLevels[n].index, this.rmapFile.zoomLevels[n].zoom, this.rmapFile.zoomLevels[n].width, this.rmapFile.zoomLevels[n].height, this.rmapFile.zoomLevels[n].xTiles, this.rmapFile.zoomLevels[n].yTiles, !this.rmapFile.zoomLevels[n].dl ? "calc" : "dl"));
        }
        this.rmapFile.writeHeader();
    }

    public void createMap() throws MapCreationException, InterruptedException {
        try {
            int index;
            for (index = 0; index < this.rmapFile.zoomLevels.length && this.rmapFile.zoomLevels[index].zoom != this.map.getZoom(); ++index) {
            }
            if (index == this.rmapFile.zoomLevels.length) {
                throw new MapCreationException("Map not found in the zoomLevels list", this.map);
            }
            try {
                this.rmapFile.zoomLevels[index].writeHeader();
            }
            catch (IOException e) {
                throw new MapCreationException("rmapFile.zoomLevels[Index].writeHeader() failed: " + e.getMessage(), this.map, e);
            }
            int tilex = 0;
            int tiley = 0;
            this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
            if (this.map.getMapSource().getTileImageType() != TileImageType.JPG || this.map.getParameters() != null) {
                TileImageFormat imageFormat = TileImageFormat.JPEG90;
                if (this.map.getParameters() != null) {
                    imageFormat = this.map.getParameters().getFormat();
                }
                this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, imageFormat);
            }
            ImageIO.setUseCache(false);
            byte[] emptyTileData = Utilities.createEmptyTileData(this.mapSource);
            for (int x = this.xMin; x <= this.xMax; ++x) {
                tiley = 0;
                for (int y = this.yMin; y <= this.yMax; ++y) {
                    this.checkUserAbort();
                    this.atlasProgress.incMapCreationProgress();
                    try {
                        ((ZoomLevel)((RmapFile)this.rmapFile).zoomLevels[index]).jpegOffsets[tilex][tiley] = this.rmapFile.getFilePointer();
                        byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                        if (sourceTileData != null) {
                            this.rmapFile.writeIntI(7);
                            this.rmapFile.writeIntI(sourceTileData.length);
                            this.rmapFile.write(sourceTileData);
                        } else {
                            this.log.trace(String.format("Tile x=%d y=%d not found in tile archive - creating default", tilex, tiley));
                            this.rmapFile.writeIntI(7);
                            this.rmapFile.writeIntI(emptyTileData.length);
                            this.rmapFile.write(emptyTileData);
                        }
                    }
                    catch (IOException e) {
                        throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                    }
                    ++tiley;
                }
                ++tilex;
            }
        }
        catch (MapCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortAtlasCreation() throws IOException {
        try {
            this.rmapFile.setLength(0L);
        }
        finally {
            Utilities.closeFile(this.rmapFile);
        }
        super.abortAtlasCreation();
    }

    public void finishLayerCreation() throws IOException {
        try {
            int n;
            for (n = 0; n < this.rmapFile.zoomLevels.length; ++n) {
                if (this.rmapFile.zoomLevels[n].offset != 0L) continue;
                if (n == 0) {
                    throw new IOException("Missing top level map");
                }
                this.rmapFile.zoomLevels[n].shrinkFrom(this.rmapFile.zoomLevels[n - 1]);
            }
            this.rmapFile.writeMapInfo();
            this.rmapFile.writeHeader();
            for (n = 0; n < this.rmapFile.zoomLevels.length; ++n) {
                this.rmapFile.zoomLevels[n].writeHeader();
            }
            this.rmapFile.close();
        }
        catch (IOException e) {
            this.log.error("Failed writing rmap file \"" + this.rmapFile.name + "\": " + e.getMessage(), e);
            this.abortAtlasCreation();
            throw e;
        }
        this.rmapFile = null;
        super.finishLayerCreation();
    }

    private class RmapFile
    extends RandomAccessFile {
        private String name;
        private int width;
        private int height;
        private int tileWidth;
        private int tileHeight;
        private double longitudeMin;
        private double longitudeMax;
        private double latitudeMin;
        private double latitudeMax;
        private long mapDataOffset;
        private ZoomLevel[] zoomLevels;

        private RmapFile(File file) throws FileNotFoundException {
            super(file, "rw");
            this.name = "";
            this.width = 0;
            this.height = 0;
            this.tileWidth = 0;
            this.tileHeight = 0;
            this.longitudeMin = 0.0;
            this.longitudeMax = 0.0;
            this.latitudeMin = 0.0;
            this.latitudeMax = 0.0;
            this.mapDataOffset = 0L;
            this.zoomLevels = null;
            this.name = file.getName();
        }

        private int readIntI() throws IOException {
            int ch4;
            int ch3;
            int ch2;
            int ch1 = this.read();
            if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
                throw new IOException();
            }
            return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
        }

        private void writeIntI(int i) throws IOException {
            this.write(i >>> 0 & 0xFF);
            this.write(i >>> 8 & 0xFF);
            this.write(i >>> 16 & 0xFF);
            this.write(i >>> 24 & 0xFF);
        }

        private void writeLongI(long l) throws IOException {
            this.write((int)(l >>> 0) & 0xFF);
            this.write((int)(l >>> 8) & 0xFF);
            this.write((int)(l >>> 16) & 0xFF);
            this.write((int)(l >>> 24) & 0xFF);
            this.write((int)(l >>> 32) & 0xFF);
            this.write((int)(l >>> 40) & 0xFF);
            this.write((int)(l >>> 48) & 0xFF);
            this.write((int)(l >>> 56) & 0xFF);
        }

        private void writeHeader() throws IOException {
            TwoNavRMAP.this.log.trace("Writing rmap header");
            if (this.zoomLevels == null) {
                throw new IOException("zoomLevels == null");
            }
            this.seek(0L);
            this.write("CompeGPSRasterImage".getBytes());
            this.writeIntI(10);
            this.writeIntI(7);
            this.writeIntI(0);
            this.writeIntI(this.width);
            this.writeIntI(-this.height);
            this.writeIntI(24);
            this.writeIntI(1);
            this.writeIntI(this.tileWidth);
            this.writeIntI(this.tileHeight);
            this.writeLongI(this.mapDataOffset);
            this.writeIntI(0);
            this.writeIntI(this.zoomLevels.length);
            for (int n = 0; n < this.zoomLevels.length; ++n) {
                this.writeLongI(this.zoomLevels[n].offset);
            }
        }

        private void writeMapInfo() throws IOException {
            if (this.mapDataOffset == 0L) {
                this.mapDataOffset = this.getFilePointer();
            } else {
                this.seek(this.mapDataOffset);
            }
            TwoNavRMAP.this.log.trace("Writing MAP data at offset %d" + this.mapDataOffset);
            StringBuffer sbMap = new StringBuffer();
            sbMap.append("CompeGPS MAP File\r\n");
            sbMap.append("<Header>\r\n");
            sbMap.append("Version=2\r\n");
            sbMap.append("VerCompeGPS=MOBAC\r\n");
            sbMap.append("Projection=2,Mercator,\r\n");
            sbMap.append("Coordinates=1\r\n");
            sbMap.append("Datum=WGS 84\r\n");
            sbMap.append("</Header>\r\n");
            sbMap.append("<Map>\r\n");
            sbMap.append("Bitmap=" + this.name + "\r\n");
            sbMap.append("BitsPerPixel=0\r\n");
            sbMap.append(String.format("BitmapWidth=%d\r\n", this.width));
            sbMap.append(String.format("BitmapHeight=%d\r\n", this.height));
            sbMap.append("Type=10\r\n");
            sbMap.append("</Map>\r\n");
            sbMap.append("<Calibration>\r\n");
            String pointLine = "P%d=%d,%d,A,%s,%s\r\n";
            DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
            df.applyPattern("#0.00000000");
            sbMap.append(String.format(pointLine, 0, 0, 0, df.format(this.longitudeMin), df.format(this.latitudeMax)));
            sbMap.append(String.format(pointLine, 1, this.width - 1, 0, df.format(this.longitudeMax), df.format(this.latitudeMax)));
            sbMap.append(String.format(pointLine, 2, this.width - 1, this.height - 1, df.format(this.longitudeMax), df.format(this.latitudeMin)));
            sbMap.append(String.format(pointLine, 3, 0, this.height - 1, df.format(this.longitudeMin), df.format(this.latitudeMin)));
            sbMap.append("</Calibration>\r\n");
            sbMap.append("<MainPolygonBitmap>\r\n");
            String polyLine = "M%d=%d,%d\r\n";
            sbMap.append(String.format(polyLine, 0, 0, 0));
            sbMap.append(String.format(polyLine, 1, this.width, 0));
            sbMap.append(String.format(polyLine, 2, this.width, this.height));
            sbMap.append(String.format(polyLine, 3, 0, this.height));
            sbMap.append("</MainPolygonBitmap>\r\n");
            this.writeIntI(1);
            this.writeIntI(sbMap.length());
            this.write(sbMap.toString().getBytes());
        }

        static /* synthetic */ ZoomLevel[] access$1402(RmapFile x0, ZoomLevel[] x1) {
            x0.zoomLevels = x1;
            return x1;
        }
    }

    private class ZoomLevel {
        private int index = 0;
        private long offset = 0L;
        private int width = 0;
        private int height = 0;
        private int xTiles = 0;
        private int yTiles = 0;
        private long[][] jpegOffsets = null;
        private int zoom = 0;
        private boolean dl = false;

        private ZoomLevel() {
        }

        private void writeHeader() throws IOException {
            if (this.offset == 0L) {
                this.offset = TwoNavRMAP.this.rmapFile.getFilePointer();
            } else {
                TwoNavRMAP.this.rmapFile.seek(this.offset);
            }
            TwoNavRMAP.this.log.trace(String.format("Writing ZoomLevel %d (%dx%d pixels, %dx%d tiles) header at offset %d", this.index, this.width, this.height, this.xTiles, this.yTiles, this.offset));
            TwoNavRMAP.this.rmapFile.writeIntI(this.width);
            TwoNavRMAP.this.rmapFile.writeIntI(-this.height);
            TwoNavRMAP.this.rmapFile.writeIntI(this.xTiles);
            TwoNavRMAP.this.rmapFile.writeIntI(this.yTiles);
            if (this.jpegOffsets == null) {
                this.jpegOffsets = new long[this.xTiles][this.yTiles];
            }
            for (int y = 0; y < this.yTiles; ++y) {
                for (int x = 0; x < this.xTiles; ++x) {
                    TwoNavRMAP.this.rmapFile.writeLongI(this.jpegOffsets[x][y]);
                }
            }
        }

        private BufferedImage loadJpegAtOffset(long offset) throws IOException {
            if (offset == 0L) {
                throw new IOException("offset == 0");
            }
            TwoNavRMAP.this.rmapFile.seek(offset);
            int TagId = TwoNavRMAP.this.rmapFile.readIntI();
            if (TagId != 7) {
                throw new IOException("TagId != 7");
            }
            int TagLen = TwoNavRMAP.this.rmapFile.readIntI();
            byte[] jpegImageBuf = new byte[TagLen];
            TwoNavRMAP.this.rmapFile.readFully(jpegImageBuf);
            ByteArrayInputStream input = new ByteArrayInputStream(jpegImageBuf);
            return ImageIO.read(input);
        }

        private byte[] getTileData(TileImageDataWriter writer, ZoomLevel source, int x, int y) throws IOException {
            TwoNavRMAP.this.log.trace(String.format("Shrinking jpegs (%d,%d,%d - %d,%d,%d)", source.index, x, y, source.index, x + 1 < source.xTiles ? x + 1 : x, y + 1 < source.yTiles ? y + 1 : y));
            BufferedImage bi11 = this.loadJpegAtOffset(source.jpegOffsets[x][y]);
            BufferedImage bi21 = x + 1 < source.xTiles ? this.loadJpegAtOffset(source.jpegOffsets[x + 1][y]) : null;
            BufferedImage bi12 = y + 1 < source.yTiles ? this.loadJpegAtOffset(source.jpegOffsets[x][y + 1]) : null;
            BufferedImage bi22 = x + 1 < source.xTiles && y + 1 < source.yTiles ? this.loadJpegAtOffset(source.jpegOffsets[x + 1][y + 1]) : null;
            int biWidth = bi11.getWidth() + (bi21 != null ? bi21.getWidth() : 0);
            int biHeight = bi11.getHeight() + (bi12 != null ? bi12.getHeight() : 0);
            BufferedImage bi = new BufferedImage(biWidth, biHeight, 5);
            Graphics2D g = bi.createGraphics();
            g.drawImage((Image)bi11, 0, 0, null);
            if (bi21 != null) {
                g.drawImage((Image)bi21, bi11.getWidth(), 0, null);
            }
            if (bi12 != null) {
                g.drawImage((Image)bi12, 0, bi11.getHeight(), null);
            }
            if (bi22 != null) {
                g.drawImage((Image)bi22, bi11.getWidth(), bi11.getHeight(), null);
            }
            AffineTransformOp op = new AffineTransformOp(new AffineTransform(0.5, 0.0, 0.0, 0.5, 0.0, 0.0), 2);
            BufferedImage biOut = new BufferedImage(biWidth / 2, biHeight / 2, 5);
            op.filter(bi, biOut);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(biOut.getWidth() * biOut.getHeight() * 4);
            writer.processImage(biOut, buffer);
            g.dispose();
            return buffer.toByteArray();
        }

        private void shrinkFrom(ZoomLevel source) {
            try {
                TileImageJpegDataWriter writer = new TileImageJpegDataWriter(0.9);
                writer.initialize();
                this.writeHeader();
                TwoNavRMAP.this.atlasProgress.initMapCreation(this.xTiles * this.yTiles);
                for (int x = 0; x < this.xTiles; ++x) {
                    for (int y = 0; y < this.yTiles; ++y) {
                        TwoNavRMAP.this.checkUserAbort();
                        TwoNavRMAP.this.atlasProgress.incMapCreationProgress();
                        this.jpegOffsets[x][y] = TwoNavRMAP.this.rmapFile.getFilePointer();
                        byte[] tileData = this.getTileData(writer, source, 2 * x, 2 * y);
                        TwoNavRMAP.this.rmapFile.seek(this.jpegOffsets[x][y]);
                        TwoNavRMAP.this.log.trace(String.format("Writing shrunken jpeg (%d,%d,%d) at offset %d", this.index, x, y, this.jpegOffsets[x][y]));
                        TwoNavRMAP.this.rmapFile.writeIntI(7);
                        TwoNavRMAP.this.rmapFile.writeIntI(tileData.length);
                        TwoNavRMAP.this.rmapFile.write(tileData);
                        tileData = null;
                    }
                }
            }
            catch (Exception e) {
                TwoNavRMAP.this.log.error("Failed generating ZoomLevel " + this.index + ": " + e.getMessage());
            }
        }

        static /* synthetic */ long[][] access$2102(ZoomLevel x0, long[][] x1) {
            x0.jpegOffsets = x1;
            return x1;
        }
    }
}

