/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.tiledatawriter.TileImageJpegDataWriter;
import mobac.utilities.Charsets;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="TomTom Raster (image + SAT)")
public class TomTomRaster
extends AtlasCreator {
    protected File layerDir;

    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        return mapSpace instanceof MercatorPower2MapSpace && MapSpace.ProjectionCategory.SPHERE.equals((Object)mapSpace.getProjectionCategory());
    }

    protected void testAtlas() throws AtlasTestException {
        Runtime r = Runtime.getRuntime();
        long heapMaxSize = r.maxMemory();
        int maxMapSize = (int)(Math.sqrt((double)heapMaxSize / 3.0) * 0.8);
        maxMapSize = maxMapSize / 100 * 100;
        for (LayerInterface layer : this.atlas) {
            for (MapInterface map : layer) {
                int w = map.getMaxTileCoordinate().x - map.getMinTileCoordinate().x;
                int h = map.getMaxTileCoordinate().y - map.getMinTileCoordinate().y;
                if (w <= maxMapSize && h <= maxMapSize) continue;
                throw new AtlasTestException("Map size too large for memory (is: " + Math.max(w, h) + " max:  " + maxMapSize + ")", map);
            }
        }
    }

    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        this.layerDir = new File(this.atlasDir, layer.getName());
        Utilities.mkDirs(this.layerDir);
    }

    public void createMap() throws MapCreationException, InterruptedException {
        try {
            this.createImage();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (MapCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createImage() throws InterruptedException, MapCreationException {
        boolean scaleImage;
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        int mapWidth = (this.xMax - this.xMin + 1) * this.tileSize;
        int mapHeight = (this.yMax - this.yMin + 1) * this.tileSize;
        int maxImageSize = this.getMaxImageSize();
        int imageWidth = Math.min(maxImageSize, mapWidth);
        int imageHeight = Math.min(maxImageSize, mapHeight);
        int len = Math.max(mapWidth, mapHeight);
        double scaleFactor = 1.0;
        boolean bl = scaleImage = len > maxImageSize;
        if (scaleImage) {
            scaleFactor = (double)this.getMaxImageSize() / (double)len;
            if (mapWidth != mapHeight) {
                if (mapWidth > mapHeight) {
                    imageHeight = (int)(scaleFactor * (double)mapHeight);
                } else {
                    imageWidth = (int)(scaleFactor * (double)mapWidth);
                }
            }
        }
        if (imageHeight < 0 || imageWidth < 0) {
            throw new MapCreationException("Invalid map size: (width/height: " + imageWidth + "/" + imageHeight + ")", this.map);
        }
        long imageSize = 3L * (long)imageWidth * (long)imageHeight;
        if (imageSize > Integer.MAX_VALUE) {
            throw new MapCreationException("Map image too large: (width/height: " + imageWidth + "/" + imageHeight + ") - reduce the map size and try again", this.map);
        }
        BufferedImage tileImage = new BufferedImage(imageWidth, imageHeight, 5);
        Graphics2D graphics = tileImage.createGraphics();
        try {
            if (scaleImage) {
                graphics.setTransform(AffineTransform.getScaleInstance(scaleFactor, scaleFactor));
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            int lineY = 0;
            for (int y = this.yMin; y <= this.yMax; ++y) {
                int lineX = 0;
                for (int x = this.xMin; x <= this.xMax; ++x) {
                    this.checkUserAbort();
                    this.atlasProgress.incMapCreationProgress();
                    try {
                        byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                        if (sourceTileData != null) {
                            BufferedImage tile = ImageIO.read(new ByteArrayInputStream(sourceTileData));
                            graphics.drawImage(tile, lineX, lineY, Color.WHITE, null);
                        }
                    }
                    catch (IOException e) {
                        this.log.error("", e);
                    }
                    lineX += this.tileSize;
                }
                lineY += this.tileSize;
            }
        }
        finally {
            graphics.dispose();
        }
        this.writeTileImage(tileImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTileImage(BufferedImage tileImage) throws MapCreationException {
        TileImageDataWriter writer = this.parameters != null ? this.parameters.getFormat().getDataWriter() : new TileImageJpegDataWriter(0.9);
        writer.initialize();
        try {
            int initialBufferSize = tileImage.getWidth() * tileImage.getHeight() / 4;
            ByteArrayOutputStream buf = new ByteArrayOutputStream(initialBufferSize);
            writer.processImage(tileImage, buf);
            String imageFileName = this.map.getName() + "." + (Object)((Object)writer.getType());
            File imageFile = new File(this.layerDir, imageFileName);
            FileOutputStream fout = new FileOutputStream(imageFile);
            try {
                fout.write(buf.toByteArray());
                fout.flush();
            }
            finally {
                fout.close();
            }
            this.writeSatFile(imageFileName, tileImage.getWidth(), tileImage.getHeight());
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    protected void writeSatFile(String imageFileName, int width, int height) throws IOException {
        int startX = this.xMin * this.tileSize;
        int startY = this.yMin * this.tileSize;
        MapSpace mapSpace = this.mapSource.getMapSpace();
        DecimalFormat df = Utilities.FORMAT_6_DEC_ENG;
        String longitudeMin = df.format(mapSpace.cXToLon(startX, this.zoom));
        String longitudeMax = df.format(mapSpace.cXToLon(startX + width, this.zoom));
        String latitudeMin = df.format(mapSpace.cYToLat(startY + height, this.zoom));
        String latitudeMax = df.format(mapSpace.cYToLat(startY, this.zoom));
        StringWriter sw = new StringWriter();
        sw.write(imageFileName + "\r\n");
        sw.write(longitudeMin + "\r\n");
        sw.write(latitudeMax + "\r\n");
        sw.write(longitudeMax + "\r\n");
        sw.write(latitudeMin + "\r\n");
        sw.write("0\r\n");
        sw.write("65535\r\n");
        sw.write(Integer.toString(width) + "\r\n");
        sw.write(Integer.toString(height));
        int i = imageFileName.lastIndexOf(46);
        String satFileName = imageFileName.substring(0, i) + ".sat";
        FileOutputStream fout = new FileOutputStream(new File(this.layerDir, satFileName));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fout, Charsets.ISO_8859_1);
        writer.append(sw.toString());
        writer.flush();
        writer.close();
    }

    protected int getMaxImageSize() {
        return 2048;
    }
}

