/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.Glopus;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="PNG + Worldfile (PNG & PGW)")
public class PNGWorldfile
extends Glopus {
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDir(this.layerDir);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        this.createTiles();
        this.writeWorldFile();
        this.writeProjectionFile();
    }

    private void writeWorldFile() throws MapCreationException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(this.layerDir, this.mapName + ".pgw"));
            OutputStreamWriter mapWriter = new OutputStreamWriter((OutputStream)fout, TEXT_FILE_CHARSET);
            double worldSize = 4.007501668557849E7;
            double maxTiles = 1 << this.zoom;
            double pixelSize = worldSize / (maxTiles * (double)this.tileSize);
            mapWriter.write(String.format(Locale.ENGLISH, "%.15f\n", pixelSize));
            mapWriter.write("0.0\n");
            mapWriter.write("0.0\n");
            mapWriter.write(String.format(Locale.ENGLISH, "%.15f\n", -pixelSize));
            double xMin1 = worldSize * ((double)this.xMin / maxTiles - 0.5);
            double yMax1 = worldSize * (0.5 - (double)this.yMin / maxTiles);
            mapWriter.write(String.format(Locale.ENGLISH, "%.7f\n", xMin1 + 0.5 * pixelSize));
            mapWriter.write(String.format(Locale.ENGLISH, "%.7f\n", yMax1 - 0.5 * pixelSize));
            mapWriter.flush();
            mapWriter.close();
        }
        catch (IOException e) {
            try {
                throw new MapCreationException(this.map, (Throwable)e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(fout);
                throw throwable;
            }
        }
        Utilities.closeStream(fout);
    }

    private void writeProjectionFile() throws MapCreationException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(this.layerDir, this.mapName + ".png.aux.xml"));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fout, TEXT_FILE_CHARSET);
            writer.write("<PAMDataset><SRS>PROJCS[&quot;WGS 84 / Pseudo-Mercator&quot;,GEOGCS[&quot;WGS 84&quot;,DATUM[&quot;WGS_1984&quot;,SPHEROID[&quot;WGS 84&quot;,6378137,298.257223563,AUTHORITY[&quot;EPSG&quot;,&quot;7030&quot;]],AUTHORITY[&quot;EPSG&quot;,&quot;6326&quot;]],PRIMEM[&quot;Greenwich&quot;,0],UNIT[&quot;degree&quot;,0.0174532925199433],AUTHORITY[&quot;EPSG&quot;,&quot;4326&quot;]],PROJECTION[&quot;Mercator_1SP&quot;],PARAMETER[&quot;central_meridian&quot;,0],PARAMETER[&quot;scale_factor&quot;,1],PARAMETER[&quot;false_easting&quot;,0],PARAMETER[&quot;false_northing&quot;,0],UNIT[&quot;metre&quot;,1,AUTHORITY[&quot;EPSG&quot;,&quot;9001&quot;]],EXTENSION[&quot;PROJ4&quot;,&quot;+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs&quot;],AUTHORITY[&quot;EPSG&quot;,&quot;3857&quot;]]</SRS></PAMDataset>");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            try {
                throw new MapCreationException(this.map, (Throwable)e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(fout);
                throw throwable;
            }
        }
        Utilities.closeStream(fout);
    }
}

