/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.RequiresSQLite;
import mobac.program.model.TileImageParameters;
import mobac.utilities.jdbc.SQLiteLoader;

@AtlasCreatorName(value="Osmdroid SQLite")
@SupportedParameters(names={TileImageParameters.Name.format})
public class OsmdroidSQLite
extends AtlasCreator
implements RequiresSQLite {
    protected Connection conn = null;

    public OsmdroidSQLite() {
        SQLiteLoader.loadSQLiteOrShowError();
    }

    public boolean testMapSource(MapSource mapSource) {
        return mapSource.getMapSpace().getProjectionCategory().equals((Object)MapSpace.ProjectionCategory.SPHERE);
    }

    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws IOException, AtlasTestException, InterruptedException {
        super.startAtlasCreation(atlas, customAtlasDir);
        String databaseFile = new File(this.atlasDir, atlas.getName() + ".sqlite").getAbsolutePath();
        try {
            SQLiteLoader.loadSQLite();
        }
        catch (SQLException e) {
            throw new AtlasTestException(SQLiteLoader.getMsgSqliteMissing());
        }
        try {
            this.conn = DriverManager.getConnection("jdbc:sqlite:" + databaseFile);
            Statement stat = this.conn.createStatement();
            stat.executeUpdate("CREATE TABLE IF NOT EXISTS tiles (key INTEGER PRIMARY KEY, provider TEXT, tile BLOB)");
            stat.close();
        }
        catch (SQLException e) {
            throw new IOException("Error creating SQL database \"" + databaseFile + "\": " + e.getMessage(), e);
        }
        this.log.debug("SQLite Database file: " + databaseFile);
    }

    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        if (this.parameters != null) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, this.parameters.getFormat());
        }
    }

    public void createMap() throws MapCreationException, InterruptedException {
        try {
            String provider = this.map.getMapSource().getName();
            int maxMapProgress = 2 * (this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1);
            this.atlasProgress.initMapCreation(maxMapProgress);
            this.conn.setAutoCommit(false);
            int batchTileCount = 0;
            ImageIO.setUseCache(false);
            PreparedStatement prep = this.conn.prepareStatement("INSERT or REPLACE INTO tiles VALUES (?, ?, ?);");
            Runtime r = Runtime.getRuntime();
            long heapMaxSize = r.maxMemory();
            for (long x = (long)this.xMin; x <= (long)this.xMax; ++x) {
                for (long y = (long)this.yMin; y <= (long)this.yMax; ++y) {
                    this.checkUserAbort();
                    this.atlasProgress.incMapCreationProgress();
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData((int)x, (int)y);
                    if (sourceTileData == null) continue;
                    long z = this.zoom;
                    long index = ((z << (int)z) + x << (int)z) + y;
                    prep.setLong(1, index);
                    prep.setString(2, provider);
                    prep.setBytes(3, sourceTileData);
                    prep.addBatch();
                    long heapAvailable = heapMaxSize - r.totalMemory() + r.freeMemory();
                    if (heapAvailable >= 0x1400000L && batchTileCount < 1000) continue;
                    this.log.trace("Executing batch containing " + batchTileCount + " tiles");
                    prep.executeBatch();
                    prep.clearBatch();
                    System.gc();
                    this.conn.commit();
                    this.atlasProgress.incMapCreationProgress(batchTileCount);
                    batchTileCount = 0;
                }
            }
            prep.executeBatch();
            this.conn.setAutoCommit(true);
            this.atlasProgress.setMapCreationProgress(maxMapProgress);
        }
        catch (SQLException e) {
            throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
        }
        catch (IOException e) {
            throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
        }
    }

    public void abortAtlasCreation() throws IOException {
        SQLiteLoader.closeConnection(this.conn);
        this.conn = null;
        super.abortAtlasCreation();
    }

    public void finishAtlasCreation() throws IOException, InterruptedException {
        SQLiteLoader.closeConnection(this.conn);
        this.conn = null;
        super.finishAtlasCreation();
    }
}

