/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.MapTileBuilder;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.CacheTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.TileImageFormat;
import mobac.program.model.TileImageParameters;
import mobac.program.tiledatawriter.TileImagePngDataWriter;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="nfComPass")
@SupportedParameters(names={TileImageParameters.Name.height, TileImageParameters.Name.width})
public class NFComPass
extends AtlasCreator {
    private File layerDir;
    private File mapDir;

    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        LayerInterface layer = map.getLayer();
        this.layerDir = new File(this.atlasDir, layer.getName());
        this.mapDir = new File(this.layerDir, map.getName());
        if (this.parameters == null) {
            this.parameters = new TileImageParameters(64, 64, TileImageFormat.PNG);
        }
    }

    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        return mapSpace instanceof MercatorPower2MapSpace && MapSpace.ProjectionCategory.SPHERE.equals((Object)mapSpace.getProjectionCategory());
    }

    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        if (layer.getMapCount() == 0) {
            return;
        }
        int lastZoom = layer.getMap(0).getZoom();
        BufferedWriter w = new BufferedWriter(new FileWriter(new File(this.atlasDir, "nfComPass.dat"), true));
        w.append("[" + layer.getName() + "]\r\n");
        w.append("SIZEXY = extern\r\n");
        w.append("MAPPATH =\r\n");
        w.append("VMAX = 160\r\n");
        w.append("WIDTH = 5\r\n");
        w.append("LASTZOOM = " + lastZoom + "\r\n\r\n");
        ((Writer)w).flush();
        ((Writer)w).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDirs(this.mapDir);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        this.createKalFile(this.map);
        CacheTileProvider ctp = new CacheTileProvider(this.mapDlTileProvider);
        try {
            this.mapDlTileProvider = ctp;
            MapTileBuilder mapTileBuilder = new MapTileBuilder(this, new TileImagePngDataWriter(), new NFCompassTileWriter(), true);
            this.atlasProgress.initMapCreation(mapTileBuilder.getCustomTileCount());
            mapTileBuilder.createTiles();
        }
        finally {
            ctp.cleanup();
        }
    }

    protected void createKalFile(MapInterface map) throws MapCreationException {
        BufferedWriter w = null;
        MapSpace mapSpace = map.getMapSource().getMapSpace();
        double longitudeMin = mapSpace.cXToLon(this.xMin * this.tileSize, this.zoom);
        double longitudeMax = mapSpace.cXToLon((this.xMax + 1) * this.tileSize - 1, this.zoom);
        double latitudeMin = mapSpace.cYToLat((this.yMax + 1) * this.tileSize - 1, this.zoom);
        double latitudeMax = mapSpace.cYToLat(this.yMin * this.tileSize, this.zoom);
        int width = (this.xMax - this.xMin + 1) * this.tileSize;
        int height = (this.yMax - this.yMin + 1) * this.tileSize;
        try {
            w = new BufferedWriter(new FileWriter(new File(this.mapDir, map.getName() + ".kal"), true));
            w.append("[" + map.getName() + "]\r\n");
            w.append(String.format("TILEXY = %dx%d\r\n", this.parameters.getWidth(), this.parameters.getHeight()));
            w.append("X0LON = " + longitudeMin + "\r\n");
            w.append("Y0LAT = " + latitudeMax + "\r\n");
            w.append("X1LON = " + longitudeMax + "\r\n");
            w.append("Y1LAT = " + latitudeMin + "\r\n");
            w.append(String.format("SIZEXY = %dx%d\r\n", width, height));
            ((Writer)w).flush();
        }
        catch (IOException e) {
            try {
                throw new MapCreationException(map, (Throwable)e);
            }
            catch (Throwable throwable) {
                Utilities.closeWriter(w);
                throw throwable;
            }
        }
        Utilities.closeWriter(w);
    }

    public class NFCompassTileWriter
    implements MapTileWriter {
        int tileHeight = 256;
        int tileWidth = 256;
        int ff_x;
        int ff_y;

        public NFCompassTileWriter() {
            if (NFComPass.this.parameters != null) {
                this.tileHeight = NFComPass.this.parameters.getHeight();
                this.tileWidth = NFComPass.this.parameters.getWidth();
            }
            int highest_bit_x = Utilities.getHighestBitSet(this.tileWidth) + 2;
            int highest_bit_y = Utilities.getHighestBitSet(this.tileHeight) + 2;
            this.ff_x = Integer.MAX_VALUE << highest_bit_x;
            this.ff_y = Integer.MAX_VALUE << highest_bit_y;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTile(int tilex, int tiley, String tileType, byte[] tileData) throws IOException {
            int x = tilex * this.tileWidth;
            int y = tiley * this.tileHeight;
            String folderName = String.format("%dx%d", x & this.ff_x, y & this.ff_y);
            String tileFileName = String.format("%d_%d.png", x, y);
            File folder = new File(NFComPass.this.mapDir, folderName);
            Utilities.mkDir(folder);
            File f = new File(folder, tileFileName);
            FileOutputStream out = new FileOutputStream(f);
            try {
                out.write(tileData);
            }
            finally {
                Utilities.closeStream(out);
            }
        }

        public void finalizeMap() throws IOException {
        }
    }
}

