/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;
import mobac.utilities.stream.ArrayOutputStream;

@AtlasCreatorName(value="MGMaps/MyTrails (MGM)", type="MGM")
@SupportedParameters(names={TileImageParameters.Name.format})
public class MGMaps
extends AtlasCreator {
    private double xResizeRatio = 1.0;
    private double yResizeRatio = 1.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws AtlasTestException, IOException, InterruptedException {
        super.startAtlasCreation(atlas, customAtlasDir);
        File cache_conf = new File(this.atlasDir, "cache.conf");
        PrintWriter pw = new PrintWriter(new FileWriter(cache_conf));
        try {
            pw.println("version=3");
            pw.println("tiles_per_file=64");
            pw.println("hash_size=1");
        }
        finally {
            pw.close();
        }
    }

    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.xResizeRatio = 1.0;
        this.yResizeRatio = 1.0;
        if (this.parameters != null) {
            int mapTileSize = map.getMapSource().getMapSpace().getTileSize();
            if (this.parameters.getWidth() != mapTileSize || this.parameters.getHeight() != mapTileSize) {
                this.xResizeRatio = (double)this.parameters.getWidth() / (double)mapTileSize;
                this.yResizeRatio = (double)this.parameters.getHeight() / (double)mapTileSize;
            } else {
                this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, this.parameters.getFormat());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMap() throws MapCreationException, InterruptedException {
        MGMTileWriter mgmTileWriter = null;
        try {
            mgmTileWriter = this.xResizeRatio != 1.0 || this.yResizeRatio != 1.0 ? new MGMResizeTileWriter() : new MGMTileWriter();
            String name = this.map.getLayer().getName();
            name = name.replaceAll("[^a-zA-Z_0-9]", "_");
            File folder = new File(this.atlasDir, name + "_" + this.map.getZoom());
            Utilities.mkDirs(folder);
            this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
            ImageIO.setUseCache(false);
            int pxMin = this.xMin / 8;
            int pxMax = this.xMax / 8;
            int pyMin = this.yMin / 8;
            int pyMax = this.yMax / 8;
            for (int px = pxMin; px <= pxMax; ++px) {
                for (int py = pyMin; py <= pyMax; ++py) {
                    int count = 0;
                    int pos = 386;
                    File pack = new File(folder, px + "_" + py + ".mgm");
                    RandomAccessFile raf = null;
                    try {
                        for (int i = 0; i < 8; ++i) {
                            int x = px * 8 + i;
                            if (x < this.xMin || x > this.xMax) continue;
                            for (int j = 0; j < 8; ++j) {
                                int y = py * 8 + j;
                                if (y < this.yMin || y > this.yMax) continue;
                                if (raf == null) {
                                    raf = new RandomAccessFile(pack, "rw");
                                }
                                this.checkUserAbort();
                                this.atlasProgress.incMapCreationProgress();
                                int res = mgmTileWriter.writeTile(x, y, i, j, raf, pos, count);
                                if (res < 0) continue;
                                pos = res;
                                ++count;
                            }
                        }
                        if (raf != null) {
                            raf.seek(0L);
                            raf.writeChar(count);
                        }
                    }
                    finally {
                        Utilities.closeFile(raf);
                    }
                    if (count != 0 || !pack.exists()) continue;
                    Utilities.deleteFile(pack);
                }
            }
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        finally {
            if (mgmTileWriter != null) {
                mgmTileWriter.dispose();
            }
        }
    }

    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        return mapSpace instanceof MercatorPower2MapSpace && (MapSpace.ProjectionCategory.SPHERE.equals((Object)mapSource.getMapSpace().getProjectionCategory()) || MapSpace.ProjectionCategory.ELLIPSOID.equals((Object)mapSource.getMapSpace().getProjectionCategory()));
    }

    private class MGMResizeTileWriter
    extends MGMTileWriter {
        private final BufferedImage tileImage;
        private final Graphics2D graphics;
        private final TileImageDataWriter writer;
        private final ArrayOutputStream buffer;

        public MGMResizeTileWriter() {
            this.tileImage = new BufferedImage(MGMaps.this.parameters.getWidth(), MGMaps.this.parameters.getHeight(), 5);
            this.graphics = this.tileImage.createGraphics();
            this.graphics.setTransform(AffineTransform.getScaleInstance(MGMaps.this.xResizeRatio, MGMaps.this.yResizeRatio));
            this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.writer = MGMaps.this.parameters.getFormat().getDataWriter();
            this.buffer = new ArrayOutputStream(3 * MGMaps.this.parameters.getWidth() * MGMaps.this.parameters.getHeight());
        }

        protected byte[] getSourceTileData(int x, int y) throws IOException {
            BufferedImage tile = MGMaps.this.mapDlTileProvider.getTileImage(x, y);
            this.graphics.drawImage((Image)tile, 0, 0, null);
            this.buffer.reset();
            this.writer.initialize();
            this.writer.processImage(this.tileImage, this.buffer);
            byte[] processedTileData = this.buffer.toByteArray();
            this.buffer.reset();
            return processedTileData;
        }

        public void dispose() {
            this.buffer.reset();
            this.graphics.dispose();
        }
    }

    private class MGMTileWriter {
        private MGMTileWriter() {
        }

        protected byte[] getSourceTileData(int x, int y) throws IOException {
            return MGMaps.this.mapDlTileProvider.getTileData(x, y);
        }

        public int writeTile(int x, int y, int i, int j, RandomAccessFile raf, int startPos, int count) throws MapCreationException {
            try {
                byte[] sourceTileData = this.getSourceTileData(x, y);
                if (sourceTileData == null) {
                    return -1;
                }
                raf.seek(startPos);
                raf.write(sourceTileData);
                raf.seek(2 + count * 6);
                raf.writeByte(i);
                raf.writeByte(j);
                int pos = startPos + sourceTileData.length;
                raf.writeInt(pos);
                return pos;
            }
            catch (IOException e) {
                throw new MapCreationException("Error writing tile image: " + e.getMessage(), MGMaps.this.map, e);
            }
        }

        public void dispose() {
        }
    }
}

