/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.awt.Desktop;
import java.io.File;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import mobac.StartMOBAC;
import mobac.program.DirectoryManager;
import mobac.program.ProgramInfo;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.Juli2Log4jHandler;
import mobac.utilities.OSUtilities;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class Logging {
    protected static File CONFIG_FILE = null;
    public static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger("MAC");
    public static final Layout ADVANCED_LAYOUT = new PatternLayout("%d{ISO8601} %-5p [%t] %c{1}: %m%n");
    protected static boolean CONFIGURED = false;

    public static void configureLogging() {
        if (!Logging.loadLog4JConfigXml()) {
            Logging.configureDefaultErrorLogging();
            org.apache.log4j.Logger logger = org.apache.log4j.Logger.getRootLogger();
            logger.info("log4.xml not found - enabling default error log to console");
        }
    }

    public static boolean loadLog4JConfigXml() {
        if (Logging.loadLog4JConfigXml(DirectoryManager.userAppDataDir)) {
            return true;
        }
        if (Logging.loadLog4JConfigXml(DirectoryManager.userSettingsDir)) {
            return true;
        }
        if (Logging.loadLog4JConfigXml(DirectoryManager.currentDir)) {
            return true;
        }
        return Logging.loadLog4JConfigXml(DirectoryManager.programDir);
    }

    public static boolean loadLog4JConfigXml(File directory) {
        File f = new File(directory, "log4j.xml");
        if (!f.isFile()) {
            return false;
        }
        try {
            DOMConfigurator.configure(f.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.println("Error loading log4j config file \"" + f.getAbsolutePath() + "\"");
            return false;
        }
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger("LogSystem");
        logger.setLevel(org.apache.log4j.Level.INFO);
        logger.info("Logging configured by \"" + f.getAbsolutePath() + "\"");
        CONFIGURED = true;
        return true;
    }

    public static void configureDefaultErrorLogging() {
        org.apache.log4j.Logger.getRootLogger().setLevel(org.apache.log4j.Level.INFO);
        Logging.configureConsoleLogging(org.apache.log4j.Level.TRACE, new SimpleLayout());
        Logging.configureLogFileLogging(org.apache.log4j.Level.TRACE);
    }

    public static void configureConsoleLogging() {
        Logging.configureConsoleLogging(org.apache.log4j.Level.ERROR, new SimpleLayout());
    }

    public static void configureConsoleLogging(org.apache.log4j.Level level) {
        Logging.configureConsoleLogging(level, new SimpleLayout());
    }

    public static void configureConsoleLogging(org.apache.log4j.Level level, Layout layout) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getRootLogger();
        ConsoleAppender consoleAppender = new ConsoleAppender(layout);
        if (level != null) {
            consoleAppender.setThreshold(level);
        }
        logger.addAppender(consoleAppender);
        CONFIGURED = true;
    }

    public static void configureLogFileLogging(org.apache.log4j.Level level) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getRootLogger();
        File logFileDir = DirectoryManager.userAppDataDir;
        String logFilename = new File(logFileDir, "Mobile Atlas Creator.log").getAbsolutePath();
        PatternLayout layout = new PatternLayout("%d{ISO8601} %-5p [%t] %c{1}: %m%n");
        try {
            FileAppender fileAppender = new FileAppender(layout, logFilename, false);
            if (level != null) {
                fileAppender.setThreshold(level);
            }
            logger.addAppender(fileAppender);
        }
        catch (Exception e) {
            org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger("LogSystem");
            log.error("", e);
        }
    }

    public static void disableLogging() {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getRootLogger();
        logger.setLevel(org.apache.log4j.Level.OFF);
    }

    public static void enableJAXBLogging() {
        Juli2Log4jHandler h = new Juli2Log4jHandler();
        Logger logger = Logger.getLogger("javax.xml.bind");
        logger.setLevel(Level.ALL);
        logger.addHandler(h);
        logger = Logger.getLogger("com.sun.xml.internal.bind");
        logger.setLevel(Level.ALL);
        logger.addHandler(h);
    }

    public static void logSystemInfo() {
        org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger("SysInfo");
        if (log.isInfoEnabled()) {
            String n = System.getProperty("line.separator");
            log.info("Version: " + ProgramInfo.getCompleteTitle());
            log.info("Platform: " + GUIExceptionHandler.prop("os.name") + " (" + GUIExceptionHandler.prop("os.version") + ")");
            log.info("Java VM: " + GUIExceptionHandler.prop("java.vm.name") + " (" + GUIExceptionHandler.prop("java.runtime.version") + ")");
            log.info("Directories:" + n + "currentDir: \t\t" + DirectoryManager.currentDir + n + "programDir: \t\t" + DirectoryManager.programDir + n + "tempDir:     \t\t" + DirectoryManager.tempDir + n + "userHomeDir: \t\t" + DirectoryManager.userHomeDir + n + "userSettingsDir: \t" + DirectoryManager.userSettingsDir + n + "atlasProfilesDir: \t" + DirectoryManager.atlasProfilesDir + n + "userAppDataDir: \t" + DirectoryManager.userAppDataDir);
            log.info("System console available: " + (System.console() != null));
            log.info("Startup arguments (count=" + StartMOBAC.ARGS.length + "):");
            for (int i = 0; i < StartMOBAC.ARGS.length; ++i) {
                log.info("\t" + i + ": " + StartMOBAC.ARGS[i]);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Detected operating system: " + (Object)((Object)OSUtilities.detectOs()) + " (" + System.getProperty("os.name") + ")");
            boolean desktopSupport = Desktop.isDesktopSupported();
            log.debug("Desktop support: " + desktopSupport);
            if (desktopSupport) {
                Desktop d = Desktop.getDesktop();
                for (Desktop.Action a : Desktop.Action.values()) {
                    log.debug("Desktop action " + (Object)((Object)a) + " supported: " + d.isSupported(a));
                }
            }
        }
        if (log.isTraceEnabled()) {
            Properties props = System.getProperties();
            StringWriter sw = new StringWriter(16384);
            sw.write("System properties:\n");
            TreeMap<Object, Object> sortedProps = new TreeMap<Object, Object>(props);
            for (Map.Entry<Object, Object> entry : sortedProps.entrySet()) {
                sw.write(entry.getKey() + " = " + entry.getValue() + "\n");
            }
            log.trace(sw.toString());
        }
    }

    public static String getLogFile() {
        Enumeration enu = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
        while (enu.hasMoreElements()) {
            Object o = enu.nextElement();
            if (!(o instanceof FileAppender)) continue;
            FileAppender fa = (FileAppender)o;
            return fa.getFile();
        }
        return null;
    }

    public static boolean isCONFIGURED() {
        return CONFIGURED;
    }
}

