/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import mobac.exceptions.UnrecoverableDownloadException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.interfaces.FileBasedMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;

public class DebugTransparentLocalMapSource
implements FileBasedMapSource,
MapSource {
    BufferedImage image = null;
    byte[] imageData = null;
    Color backgroundColor = new Color(0, 0, 0, 0);

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public MapSpace getMapSpace() {
        return MercatorPower2MapSpace.INSTANCE_256;
    }

    public int getMaxZoom() {
        return 22;
    }

    public int getMinZoom() {
        return 0;
    }

    public TileImageType getTileImageType() {
        return TileImageType.PNG;
    }

    public void initialize() {
    }

    public void reinitialize() {
    }

    public String getName() {
        return "DebugTransparentLocal";
    }

    public String toString() {
        return "Debug Transparent (local)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
        if (this.imageData != null) {
            return this.imageData;
        }
        DebugTransparentLocalMapSource debugTransparentLocalMapSource = this;
        synchronized (debugTransparentLocalMapSource) {
            if (this.imageData != null) {
                return this.imageData;
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream(16000);
            BufferedImage image = this.getTileImage(zoom, x, y, loadMethod);
            if (image == null) {
                return null;
            }
            ImageIO.write((RenderedImage)image, "png", buf);
            this.imageData = buf.toByteArray();
            return this.imageData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
        if (this.image != null) {
            return this.image;
        }
        DebugTransparentLocalMapSource debugTransparentLocalMapSource = this;
        synchronized (debugTransparentLocalMapSource) {
            BufferedImage bufferedImage;
            if (this.image != null) {
                return this.image;
            }
            BufferedImage image = new BufferedImage(256, 256, 2);
            Graphics2D g2 = image.createGraphics();
            SecureRandom rnd = new SecureRandom();
            try {
                for (int i = 0; i < 100; ++i) {
                    g2.setColor(new Color(rnd.nextInt()));
                    int x1 = rnd.nextInt(256);
                    int y1 = rnd.nextInt(256);
                    int x2 = rnd.nextInt(256);
                    int y2 = rnd.nextInt(256);
                    g2.drawLine(x1, y1, x2, y2);
                }
                g2.setColor(Color.RED);
                this.image = image;
                bufferedImage = image;
            }
            catch (Throwable throwable) {
                g2.dispose();
                throw throwable;
            }
            g2.dispose();
            return bufferedImage;
        }
    }

    public MapSourceLoaderInfo getLoaderInfo() {
        return null;
    }

    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
    }
}

