/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import mobac.exceptions.UnrecoverableDownloadException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;
import mobac.utilities.imageio.Png4BitWriter;

public class DebugMapSource
implements MapSource {
    private int pngCompressionLevel = 1;
    private static final byte[] COLORS = new byte[]{0, -1, -1, -1, -52, -52, -52};
    private static final IndexColorModel COLORMODEL = new IndexColorModel(8, 2, COLORS, 1, false);
    private Color COLOR_BG = new Color(COLORS[1] & 0xFF, COLORS[2] & 0xFF, COLORS[3] & 0xFF);
    private Color COLOR_VG = new Color(COLORS[4] & 0xFF, COLORS[5] & 0xFF, COLORS[6] & 0xFF);
    private static final Font FONT_LARGE = new Font("Sans Serif", 1, 30);

    public Color getBackgroundColor() {
        return Color.BLACK;
    }

    public MapSpace getMapSpace() {
        return MercatorPower2MapSpace.INSTANCE_256;
    }

    public int getMaxZoom() {
        return 22;
    }

    public int getMinZoom() {
        return 0;
    }

    public String getName() {
        return "Debug";
    }

    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(16000);
        String pngMetaText = String.format("zoom=%d x=%d y=%d", zoom, x, y);
        Png4BitWriter.writeImage(buf, this.getTileImage(zoom, x, y, loadMethod), this.pngCompressionLevel, pngMetaText);
        return buf.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
        BufferedImage image = new BufferedImage(256, 256, 13, COLORMODEL);
        Graphics2D g2 = image.createGraphics();
        try {
            g2.setColor(this.COLOR_BG);
            g2.fillRect(0, 0, 255, 255);
            g2.setColor(this.COLOR_VG);
            g2.drawRect(0, 0, 255, 255);
            g2.drawRect(1, 1, 254, 254);
            g2.drawLine(0, 0, 255, 255);
            g2.drawLine(255, 0, 0, 255);
            g2.setFont(FONT_LARGE);
            g2.drawString("x: " + x, 8, 40);
            g2.drawString("y: " + y, 8, 75);
            g2.drawString("z: " + zoom, 8, 110);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            g2.dispose();
        }
    }

    public TileImageType getTileImageType() {
        return TileImageType.PNG;
    }

    public MapSourceLoaderInfo getLoaderInfo() {
        return null;
    }

    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        throw new RuntimeException("LoaderInfo can not be set");
    }

    public String toString() {
        return this.getName();
    }
}

