/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.custom;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import mobac.exceptions.TileException;
import mobac.mapsources.MapSourcesManager;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;

@XmlRootElement
public class StandardMapSourceLayer
implements MapSource {
    protected MapSource mapSource = null;
    @XmlElement(name="name")
    protected String mapSourceName;

    public MapSource getMapSource() {
        return this.mapSource;
    }

    protected void afterUnmarshal(Unmarshaller u, Object parent) {
        this.mapSource = MapSourcesManager.getInstance().getSourceByName(this.mapSourceName);
        if (this.mapSource == null) {
            throw new RuntimeException("Invalid map source name used: " + this.mapSourceName);
        }
    }

    public int getMaxZoom() {
        return this.mapSource.getMaxZoom();
    }

    public int getMinZoom() {
        return this.mapSource.getMinZoom();
    }

    public String getName() {
        return this.mapSource.getName();
    }

    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        return this.mapSource.getTileData(zoom, x, y, loadMethod);
    }

    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        return this.mapSource.getTileImage(zoom, x, y, loadMethod);
    }

    public TileImageType getTileImageType() {
        return this.mapSource.getTileImageType();
    }

    public MapSpace getMapSpace() {
        return this.mapSource.getMapSpace();
    }

    public Color getBackgroundColor() {
        return this.mapSource.getBackgroundColor();
    }

    public String toString() {
        return this.mapSource.toString();
    }

    public int hashCode() {
        return this.mapSource.hashCode();
    }

    @XmlTransient
    public MapSourceLoaderInfo getLoaderInfo() {
        return this.mapSource.getLoaderInfo();
    }

    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        this.mapSource.setLoaderInfo(loaderInfo);
    }

    public boolean equals(Object obj) {
        return this.mapSource.equals(obj);
    }
}

