/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.custom;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import mobac.exceptions.TileException;
import mobac.mapsources.MapSourceTools;
import mobac.mapsources.custom.CustomMapSourceType;
import mobac.mapsources.mapspace.MapSpaceFactory;
import mobac.program.Logging;
import mobac.program.interfaces.FileBasedMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.jaxb.ColorAdapter;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

@XmlRootElement(name="localTileZip")
public class CustomLocalTileZipMapSource
implements FileBasedMapSource {
    private static final Logger log = Logger.getLogger(CustomLocalTileZipMapSource.class);
    private MapSourceLoaderInfo loaderInfo = null;
    private MapSpace mapSpace = MapSpaceFactory.getInstance(256, true);
    private boolean initialized = false;
    private String fileSyntax = null;
    private TileImageType tileImageType = null;
    @XmlElement(nillable=false, defaultValue="CustomLocal")
    private String name = "Custom";
    private int minZoom = 0;
    private int maxZoom = 22;
    @XmlElement(name="zipFile", required=true)
    private File[] zipFiles = new File[0];
    @XmlElement
    private CustomMapSourceType sourceType = CustomMapSourceType.DIR_ZOOM_X_Y;
    @XmlElement(defaultValue="false")
    private boolean invertYCoordinate = false;
    private LinkedList<ZipFile> zips = new LinkedList();
    @XmlElement(defaultValue="#000000")
    @XmlJavaTypeAdapter(value=ColorAdapter.class)
    private Color backgroundColor = Color.BLACK;

    protected synchronized void openZipFile() {
        for (File zipFile : this.zipFiles) {
            if (!zipFile.isFile()) {
                JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_custom_map_invalid_source_zip_title", new Object[0]), this.name, zipFile.toString()), I18nUtils.localizedStringForKey("msg_custom_map_invalid_source_zip_title", new Object[0]), 0);
                continue;
            }
            try {
                Logging.LOG.debug("Opening zip file " + zipFile.getAbsolutePath());
                this.zips.add(new ZipFile(zipFile));
                Logging.LOG.debug("Zip file open completed");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_custom_map_failed_open_source_zip", new Object[0]), this.name, zipFile.toString()), I18nUtils.localizedStringForKey("msg_custom_map_failed_open_source_zip_title", new Object[0]), 0);
            }
        }
    }

    public synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.reinitialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reinitialize() {
        try {
            this.openZipFile();
            if (this.zips.size() == 0) {
                return;
            }
            switch (this.sourceType) {
                case DIR_ZOOM_X_Y: 
                case DIR_ZOOM_Y_X: {
                    this.initializeDirType();
                    return;
                }
                case QUADKEY: {
                    this.initializeQuadKeyType();
                    return;
                }
                default: {
                    throw new RuntimeException("Invalid source type");
                }
            }
        }
        finally {
            this.initialized = true;
        }
    }

    public synchronized void initializeDirType() {
        int min = 22;
        int max = 0;
        block0: for (ZipFile zip : this.zips) {
            ZipEntry entry;
            int z;
            for (z = 22; z > 0; --z) {
                entry = zip.getEntry(Integer.toString(z) + "/");
                if (entry == null) continue;
                max = Math.max(max, z);
                break;
            }
            for (z = 0; z < 22; ++z) {
                entry = zip.getEntry(Integer.toString(z) + "/");
                if (entry == null) continue;
                min = Math.min(min, z);
                continue block0;
            }
        }
        this.minZoom = min;
        this.maxZoom = max;
        Enumeration<? extends ZipEntry> entries = this.zips.get(0).entries();
        String syntax = "%d/%d/%d";
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            int i = name.lastIndexOf("/");
            String[] parts = (name = name.substring(i + 1)).split("\\.");
            if (parts.length < 2 || parts.length > 3) break;
            syntax = syntax + "." + parts[1];
            this.tileImageType = TileImageType.getTileImageType(parts[1]);
            if (parts.length == 3) {
                syntax = syntax + "." + parts[2];
            }
            this.fileSyntax = syntax;
            log.debug("Detected file syntax: " + this.fileSyntax + " tileImageType=" + (Object)((Object)this.tileImageType));
            break;
        }
    }

    public synchronized void initializeQuadKeyType() {
        Pattern p = Pattern.compile("([0123]+)\\.(png|gif|jpg)", 2);
        Enumeration<? extends ZipEntry> entries = this.zips.get(0).entries();
        String fileExt = null;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            Matcher m = p.matcher(entry.getName());
            if (!m.matches()) continue;
            fileExt = m.group(2);
            break;
        }
        if (fileExt == null) {
            return;
        }
        this.fileSyntax = "%s." + fileExt;
        this.tileImageType = TileImageType.getTileImageType(fileExt);
        p = Pattern.compile("([0123]+)\\.(" + fileExt + ")", 2);
        int min = 22;
        int max = 1;
        for (ZipFile zipFile : this.zips) {
            entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Matcher m = p.matcher(entry.getName());
                if (!m.matches()) continue;
                if (this.fileSyntax == null) {
                    this.fileSyntax = "%s." + m.group(2);
                }
                int z = m.group(1).length();
                min = Math.min(min, z);
                max = Math.max(max, z);
            }
        }
        this.minZoom = min;
        this.maxZoom = max;
    }

    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        String fileName;
        if (!this.initialized) {
            this.initialize();
        }
        if (this.fileSyntax == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("Loading tile z=%d x=%d y=%d", zoom, x, y));
        }
        if (this.invertYCoordinate) {
            y = (1 << zoom) - y - 1;
        }
        ZipEntry entry = null;
        switch (this.sourceType) {
            case DIR_ZOOM_X_Y: {
                fileName = String.format(this.fileSyntax, zoom, x, y);
                break;
            }
            case DIR_ZOOM_Y_X: {
                fileName = String.format(this.fileSyntax, zoom, y, x);
                break;
            }
            case QUADKEY: {
                fileName = String.format(this.fileSyntax, MapSourceTools.encodeQuadTree(zoom, x, y));
                break;
            }
            default: {
                throw new RuntimeException("Invalid source type");
            }
        }
        for (ZipFile zip : this.zips) {
            entry = zip.getEntry(fileName);
            if (entry == null) continue;
            InputStream in = zip.getInputStream(entry);
            byte[] data = Utilities.getInputBytes(in);
            in.close();
            return data;
        }
        log.debug("Map tile file not found in zip files: " + fileName);
        return null;
    }

    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        byte[] data = this.getTileData(zoom, x, y, loadMethod);
        if (data == null) {
            return null;
        }
        return ImageIO.read(new ByteArrayInputStream(data));
    }

    public TileImageType getTileImageType() {
        return this.tileImageType;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public MapSpace getMapSpace() {
        return this.mapSpace;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @XmlTransient
    public MapSourceLoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        this.loaderInfo = loaderInfo;
    }
}

