/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.custom;

import bsh.EvalError;
import bsh.Interpreter;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.bind.UnmarshalException;
import mobac.exceptions.TileException;
import mobac.mapsources.AbstractHttpMapSource;
import mobac.mapsources.mapspace.MapSpaceFactory;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.jaxb.ColorAdapter;
import mobac.program.model.TileImageType;
import mobac.utilities.Charsets;
import mobac.utilities.Utilities;

public class BeanShellHttpMapSource
extends AbstractHttpMapSource {
    private static final String AH_ERROR = "Sourced file: inline evaluation of: ``addHeaders(conn);'' : Command not found: addHeaders( sun.net.www.protocol.http.HttpURLConnection )";
    private static int NUM = 0;
    private final Interpreter i;
    private Color backgroundColor = Color.BLACK;
    private boolean ignoreError = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanShellHttpMapSource load(File f) throws EvalError, IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, Charsets.UTF_8));
            StringWriter sw = new StringWriter();
            String line = br.readLine();
            while (line != null) {
                sw.write(line + "\n");
                line = br.readLine();
            }
            br.close();
            BeanShellHttpMapSource beanShellHttpMapSource = new BeanShellHttpMapSource(sw.toString());
            return beanShellHttpMapSource;
        }
        finally {
            Utilities.closeStream(in);
        }
    }

    public BeanShellHttpMapSource(String code) throws EvalError {
        super("", 0, 0, TileImageType.PNG, HttpMapSource.TileUpdate.None);
        this.name = "BeanShell map source " + NUM++;
        this.i = new Interpreter();
        this.i.eval("import mobac.program.interfaces.HttpMapSource.TileUpdate;");
        this.i.eval("import java.net.HttpURLConnection;");
        this.i.eval("import mobac.utilities.beanshell.*;");
        this.i.eval(code);
        Object o = this.i.get("name");
        if (o != null) {
            this.name = (String)o;
        }
        if ((o = this.i.get("tileSize")) != null) {
            int tileSize = (Integer)o;
            this.mapSpace = MapSpaceFactory.getInstance(tileSize, true);
        } else {
            this.mapSpace = MercatorPower2MapSpace.INSTANCE_256;
        }
        o = this.i.get("minZoom");
        this.minZoom = o != null ? (Integer)o : 0;
        o = this.i.get("maxZoom");
        this.maxZoom = o != null ? (Integer)o : 22;
        o = this.i.get("tileType");
        if (o == null) {
            throw new EvalError("tileType definition missing", null, null);
        }
        this.tileType = TileImageType.getTileImageType((String)o);
        o = this.i.get("tileUpdate");
        if (o != null) {
            this.tileUpdate = (HttpMapSource.TileUpdate)((Object)o);
        }
        if ((o = this.i.get("ignoreError")) != null) {
            if (o instanceof String) {
                this.ignoreError = Boolean.parseBoolean((String)o);
            } else if (o instanceof Boolean) {
                this.ignoreError = (Boolean)o;
            } else {
                throw new EvalError("Invalid type for \"ignoreError\": " + o.getClass(), null, null);
            }
        }
        if ((o = this.i.get("backgroundColor")) != null) {
            try {
                this.backgroundColor = ColorAdapter.parseColor((String)o);
            }
            catch (UnmarshalException e) {
                throw new EvalError(e.getMessage(), null, null);
            }
        }
    }

    public synchronized HttpURLConnection getTileUrlConnection(int zoom, int tilex, int tiley) throws IOException {
        HttpURLConnection conn;
        block5: {
            conn = null;
            try {
                String url = this.getTileUrl(zoom, tilex, tiley);
                conn = (HttpURLConnection)new URL(url).openConnection();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", e);
                throw new IOException(e);
            }
            try {
                this.i.set("conn", conn);
                this.i.eval("addHeaders(conn);");
            }
            catch (EvalError e) {
                String msg = e.getMessage();
                if (AH_ERROR.equals(msg)) break block5;
                this.log.error(e.getClass() + ": " + e.getMessage(), e);
                throw new IOException(e);
            }
        }
        return conn;
    }

    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        if (!this.ignoreError) {
            return super.getTileData(zoom, x, y, loadMethod);
        }
        try {
            return super.getTileData(zoom, x, y, loadMethod);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean testCode() throws IOException {
        return this.getTileUrlConnection(this.minZoom, 0, 0) != null;
    }

    public String getTileUrl(int zoom, int tilex, int tiley) {
        try {
            return (String)this.i.eval(String.format("getTileUrl(%d,%d,%d);", zoom, tilex, tiley));
        }
        catch (EvalError e) {
            this.log.error(e.getClass() + ": " + e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public MapSpace getMapSpace() {
        return this.mapSpace;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public String getName() {
        return this.name;
    }

    public HttpMapSource.TileUpdate getTileUpdate() {
        return this.tileUpdate;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }
}

