/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.panels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import mobac.gui.components.JCollapsiblePanel;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.controller.JMapController;
import mobac.gui.mapview.interfaces.MapEventListener;
import mobac.gui.mapview.layer.TileStoreCoverageLayer;
import mobac.mapsources.AbstractMultiLayerMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.model.MercatorPixelCoordinate;
import mobac.utilities.GBC;
import mobac.utilities.I18nUtils;

public class JTileStoreCoveragePanel
extends JCollapsiblePanel
implements ActionListener,
MapEventListener {
    private static final long serialVersionUID = 1L;
    private JButton showCoverage;
    private JButton hideCoverage;
    private JComboBox layerSelector;
    private JComboBox zoomCombo;
    private PreviewMap mapViewer;

    public JTileStoreCoveragePanel(PreviewMap mapViewer) {
        super(I18nUtils.localizedStringForKey("lp_tile_store_title", new Object[0]));
        this.contentContainer.setLayout(new GridBagLayout());
        this.mapViewer = mapViewer;
        this.showCoverage = new JButton(I18nUtils.localizedStringForKey("lp_tile_store_show_coverage_btn_title", new Object[0]));
        this.showCoverage.addActionListener(this);
        this.showCoverage.setToolTipText(I18nUtils.localizedStringForKey("lp_tile_store_show_coverage_btn_tips", new Object[0]));
        this.hideCoverage = new JButton(I18nUtils.localizedStringForKey("lp_tile_store_hide_coverage_btn_title", new Object[0]));
        this.hideCoverage.addActionListener(this);
        this.hideCoverage.setEnabled(false);
        this.zoomCombo = new JComboBox();
        this.zoomCombo.setToolTipText(I18nUtils.localizedStringForKey("lp_tile_store_zoom_combo_tips", new Object[0]));
        this.titlePanel.setToolTipText(I18nUtils.localizedStringForKey("lp_tile_store_title_tips", new Object[0]));
        this.layerSelector = new JComboBox();
        GBC gbc_eol = GBC.eol().insets(2, 2, 2, 2);
        GBC gbc_std = GBC.std().insets(2, 2, 2, 2);
        this.contentContainer.add((Component)new JLabel(I18nUtils.localizedStringForKey("lp_tile_store_zoom_title", new Object[0])), gbc_std);
        this.contentContainer.add((Component)this.zoomCombo, gbc_eol);
        this.contentContainer.add((Component)new JLabel(I18nUtils.localizedStringForKey("lp_tile_store_layer_title", new Object[0])), gbc_std);
        this.contentContainer.add((Component)this.layerSelector, gbc_eol);
        this.contentContainer.add((Component)this.showCoverage, gbc_eol.fillH());
        this.contentContainer.add((Component)this.hideCoverage, gbc_eol.fillH());
        this.mapSourceChanged(mapViewer.getMapSource());
        mapViewer.addMapEventListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.hideCoverage.equals(e.getSource())) {
            TileStoreCoverageLayer.removeCacheCoverageLayers();
            this.mapViewer.repaint();
            this.hideCoverage.setEnabled(false);
            return;
        }
        Integer zoom = (Integer)this.zoomCombo.getSelectedItem();
        if (zoom == null) {
            return;
        }
        TileStoreCoverageLayer.removeCacheCoverageLayers();
        this.mapViewer.repaint();
        TileStoreCoverageLayer tscl = new TileStoreCoverageLayer(this.mapViewer, (MapSource)this.layerSelector.getSelectedItem(), zoom);
        this.mapViewer.mapLayers.add(tscl);
        this.hideCoverage.setEnabled(true);
    }

    public void mapSourceChanged(MapSource newMapSource) {
        MapSource[] layers;
        TileStoreCoverageLayer.removeCacheCoverageLayers();
        this.hideCoverage.setEnabled(false);
        Integer selZoom = (Integer)this.zoomCombo.getSelectedItem();
        if (selZoom == null) {
            selZoom = new Integer(8);
        }
        int zoomLevels = Math.max(0, newMapSource.getMaxZoom() - newMapSource.getMinZoom() + 1);
        Integer[] items = new Integer[zoomLevels];
        int zoom = newMapSource.getMinZoom();
        for (int i = 0; i < items.length; ++i) {
            items[i] = new Integer(zoom++);
        }
        this.zoomCombo.setModel(new DefaultComboBoxModel<Integer>(items));
        this.zoomCombo.setMaximumRowCount(10);
        this.zoomCombo.setSelectedItem(selZoom);
        if (newMapSource instanceof AbstractMultiLayerMapSource) {
            layers = ((AbstractMultiLayerMapSource)newMapSource).getLayerMapSources();
            this.layerSelector.setEnabled(true);
        } else {
            layers = new MapSource[]{newMapSource};
            this.layerSelector.setEnabled(false);
        }
        this.layerSelector.setModel(new DefaultComboBoxModel<MapSource>(layers));
        this.layerSelector.setSelectedIndex(0);
    }

    public void selectNextMapSource() {
    }

    public void selectPreviousMapSource() {
    }

    public void selectionChanged(MercatorPixelCoordinate max, MercatorPixelCoordinate min) {
    }

    public void zoomChanged(int newZoomLevel) {
    }

    public void mapSelectionControllerChanged(JMapController newMapController) {
    }
}

