/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.layer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import mobac.gui.mapview.JMapViewer;
import mobac.gui.mapview.controller.AbstractPolygonSelectionMapController;
import mobac.gui.mapview.interfaces.MapLayer;
import mobac.program.interfaces.MapSpace;

public class PolygonSelectionLayer
implements MapLayer {
    private final AbstractPolygonSelectionMapController mapController;

    public PolygonSelectionLayer(AbstractPolygonSelectionMapController mapController) {
        this.mapController = mapController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(JMapViewer map, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        MapSpace mapSpace = map.getMapSource().getMapSpace();
        g.setColor(Color.RED);
        Point lastPoint = null;
        ArrayList<Point> pointList = this.mapController.getPolygonPoints();
        if (pointList.size() == 0) {
            return;
        }
        AffineTransform at = g.getTransform();
        try {
            g.translate(-minX, -minY);
            for (Point p : pointList) {
                Point p1 = mapSpace.changeZoom(p, 22, zoom);
                g.fillOval(p1.x - 3, p1.y - 3, 6, 6);
                if (lastPoint != null) {
                    g.drawLine(p1.x, p1.y, lastPoint.x, lastPoint.y);
                }
                lastPoint = p1;
            }
            Point p1 = mapSpace.changeZoom((Point)pointList.get(0), 22, zoom);
            g.drawLine(p1.x, p1.y, lastPoint.x, lastPoint.y);
        }
        finally {
            g.setTransform(at);
        }
    }
}

