/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.layer;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Iterator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import mobac.gui.MainGUI;
import mobac.gui.atlastree.JAtlasTree;
import mobac.gui.mapview.JMapViewer;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.interfaces.MapLayer;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.AtlasObject;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.MapPolygon;

public class MapAreaHighlightingLayer
implements TreeModelListener,
MapLayer {
    private final JAtlasTree tree;
    private TreeSelectionListener treeListener;
    private AtlasObject object;

    public static void removeHighlightingLayers() {
        PreviewMap previewMap = MainGUI.getMainGUI().previewMap;
        Iterator mapLayers = previewMap.mapLayers.iterator();
        while (mapLayers.hasNext()) {
            MapLayer ml = (MapLayer)mapLayers.next();
            if (!(ml instanceof MapAreaHighlightingLayer)) continue;
            mapLayers.remove();
            ((MapAreaHighlightingLayer)ml).unregisterTreeListener();
        }
    }

    public MapAreaHighlightingLayer(AtlasObject atlasObject) {
        this.tree = null;
        this.treeListener = null;
        this.object = atlasObject;
    }

    public MapAreaHighlightingLayer(JAtlasTree tree) {
        this.tree = tree;
        this.object = (AtlasObject)tree.getSelectionPath().getLastPathComponent();
        MainGUI.getMainGUI().previewMap.repaint();
        this.treeListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                try {
                    MapAreaHighlightingLayer.this.object = (AtlasObject)event.getNewLeadSelectionPath().getLastPathComponent();
                }
                catch (Exception e) {
                    MapAreaHighlightingLayer.this.object = null;
                }
                MainGUI.getMainGUI().previewMap.repaint();
            }
        };
        tree.addTreeSelectionListener(this.treeListener);
        tree.getModel().addTreeModelListener(this);
    }

    public void paint(JMapViewer mapViewer, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        if (this.object == null) {
            return;
        }
        if (this.object instanceof AtlasInterface) {
            for (LayerInterface layer : (AtlasInterface)this.object) {
                for (MapInterface map : layer) {
                    this.paintMap(map, g, zoom, minX, minY, maxX, maxY);
                }
            }
        } else if (this.object instanceof LayerInterface) {
            for (MapInterface map : (LayerInterface)this.object) {
                this.paintMap(map, g, zoom, minX, minY, maxX, maxY);
            }
        } else {
            this.paintMap((MapInterface)this.object, g, zoom, minX, minY, maxX, maxY);
        }
    }

    protected void paintMap(MapInterface map, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        if (map instanceof MapPolygon) {
            this.paintMapPolygon((MapPolygon)map, g, zoom, minX, minY, maxX, maxY);
        } else {
            this.paintMapRectangle(map, g, zoom, minX, minY, maxX, maxY);
        }
    }

    protected void paintMapRectangle(MapInterface map, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        Point max = map.getMaxTileCoordinate();
        Point min = map.getMinTileCoordinate();
        int zoomDiff = map.getZoom() - zoom;
        int mapX = MapAreaHighlightingLayer.applyZoomDiff(min.x, zoomDiff);
        int mapY = MapAreaHighlightingLayer.applyZoomDiff(min.y, zoomDiff);
        int mapW = MapAreaHighlightingLayer.applyZoomDiff(max.x - min.x + 1, zoomDiff);
        int mapH = MapAreaHighlightingLayer.applyZoomDiff(max.y - min.y + 1, zoomDiff);
        int x = mapX - minX;
        int y = mapY - minY;
        int w = mapW;
        int h = mapH;
        g.setColor(PreviewMap.MAP_COLOR);
        g.fillRect(x, y, w, h);
        g.setColor(PreviewMap.GRID_COLOR);
        g.drawRect(x, y, w, h);
    }

    protected void paintMapPolygon(MapPolygon map, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        Polygon p = map.getPolygon();
        int zoomDiff = map.getZoom() - zoom;
        int[] px = new int[p.npoints];
        int[] py = new int[p.npoints];
        for (int i = 0; i < px.length; ++i) {
            px[i] = MapAreaHighlightingLayer.applyZoomDiff(p.xpoints[i], zoomDiff) - minX;
            py[i] = MapAreaHighlightingLayer.applyZoomDiff(p.ypoints[i], zoomDiff) - minY;
        }
        g.setColor(PreviewMap.MAP_COLOR);
        g.fillPolygon(px, py, px.length);
    }

    private static int applyZoomDiff(int pixelCoord, int zoomDiff) {
        return zoomDiff > 0 ? pixelCoord >> zoomDiff : pixelCoord << -zoomDiff;
    }

    protected void unregisterTreeListener() {
        if (this.treeListener == null) {
            return;
        }
        try {
            this.tree.getModel().removeTreeModelListener(this);
            this.tree.removeTreeSelectionListener(this.treeListener);
            this.treeListener = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.unregisterTreeListener();
        super.finalize();
    }

    public void treeNodesChanged(TreeModelEvent e) {
        MainGUI.getMainGUI().previewMap.repaint();
    }

    public void treeNodesInserted(TreeModelEvent e) {
        MainGUI.getMainGUI().previewMap.repaint();
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        MainGUI.getMainGUI().previewMap.repaint();
    }

    public void treeStructureChanged(TreeModelEvent e) {
        MainGUI.getMainGUI().previewMap.repaint();
    }

    public void setObject(AtlasObject object) {
        this.object = object;
    }
}

