/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.controller;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.controller.JMapController;
import mobac.utilities.OSUtilities;

public class DefaultMapController
extends JMapController
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private Point lastDragPoint;
    private boolean isMoving = false;
    private boolean movementEnabled = true;
    private int movementMouseButton = 3;
    private int movementMouseButtonMask = 4096;
    private boolean wheelZoomEnabled = true;
    private boolean doubleClickZoomEnabled = true;

    public DefaultMapController(PreviewMap map) {
        super(map, true);
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.movementEnabled || !this.isMoving) {
            return;
        }
        if ((e.getModifiersEx() & 0x1C00) == this.movementMouseButtonMask) {
            Point p = e.getPoint();
            if (this.lastDragPoint != null) {
                int diffx = this.lastDragPoint.x - p.x;
                int diffy = this.lastDragPoint.y - p.y;
                this.map.moveMap(diffx, diffy);
            }
            this.lastDragPoint = p;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.doubleClickZoomEnabled && e.getClickCount() == 2 && e.getButton() == 1) {
            this.map.zoomIn(e.getPoint());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == this.movementMouseButton || OSUtilities.isPlatformOsx() && e.getModifiersEx() == 1152) {
            this.lastDragPoint = null;
            this.isMoving = true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == this.movementMouseButton || OSUtilities.isPlatformOsx() && e.getButton() == 1) {
            this.lastDragPoint = null;
            this.isMoving = false;
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.wheelZoomEnabled) {
            this.map.setZoom(this.map.getZoom() - e.getWheelRotation(), e.getPoint());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (!(OSUtilities.isPlatformOsx() && this.movementEnabled && this.isMoving)) {
            return;
        }
        if (e.getModifiersEx() == 128) {
            Point p = e.getPoint();
            if (this.lastDragPoint != null) {
                int diffx = this.lastDragPoint.x - p.x;
                int diffy = this.lastDragPoint.y - p.y;
                this.map.moveMap(diffx, diffy);
            }
            this.lastDragPoint = p;
        }
    }
}

