/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.awt.image.BufferedImage;
import java.net.ConnectException;
import mobac.exceptions.DownloadFailedException;
import mobac.gui.mapview.JobDispatcher;
import mobac.gui.mapview.MemoryTileCache;
import mobac.gui.mapview.Tile;
import mobac.gui.mapview.interfaces.TileLoaderListener;
import mobac.program.download.TileDownLoader;
import mobac.program.interfaces.MapSource;
import mobac.program.tilestore.TileStore;
import mobac.program.tilestore.TileStoreEntry;
import org.apache.log4j.Logger;

public class TileLoader {
    private static final Logger log = Logger.getLogger(TileLoader.class);
    protected TileStore tileStore;
    protected TileLoaderListener listener;

    public TileLoader(TileLoaderListener listener) {
        this.listener = listener;
        this.tileStore = TileStore.getInstance();
    }

    public Runnable createTileLoaderJob(MapSource source, int tilex, int tiley, int zoom) {
        return new TileAsyncLoadJob(source, tilex, tiley, zoom);
    }

    protected class TileAsyncLoadJob
    implements Runnable {
        final int tilex;
        final int tiley;
        final int zoom;
        final MapSource mapSource;
        Tile tile;
        boolean fileTilePainted = false;
        protected TileStoreEntry tileStoreEntry = null;

        public TileAsyncLoadJob(MapSource source, int tilex, int tiley, int zoom) {
            this.mapSource = source;
            this.tilex = tilex;
            this.tiley = tiley;
            this.zoom = zoom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MemoryTileCache cache;
            MemoryTileCache memoryTileCache = cache = TileLoader.this.listener.getTileImageCache();
            synchronized (memoryTileCache) {
                this.tile = cache.getTile(this.mapSource, this.tilex, this.tiley, this.zoom);
                if (this.tile == null || this.tile.tileState != Tile.TileState.TS_NEW) {
                    return;
                }
                this.tile.setTileState(Tile.TileState.TS_LOADING);
            }
            if (this.loadTileFromStore()) {
                return;
            }
            if (this.fileTilePainted) {
                Runnable job = new Runnable(){

                    public void run() {
                        TileAsyncLoadJob.this.loadOrUpdateTile();
                    }
                };
                JobDispatcher.getInstance().addJob(job);
            } else {
                this.loadOrUpdateTile();
            }
        }

        protected void loadOrUpdateTile() {
            try {
                BufferedImage image = this.mapSource.getTileImage(this.zoom, this.tilex, this.tiley, MapSource.LoadMethod.DEFAULT);
                if (image != null) {
                    this.tile.setImage(image);
                    this.tile.setTileState(Tile.TileState.TS_LOADED);
                    TileLoader.this.listener.tileLoadingFinished(this.tile, true);
                } else {
                    this.tile.setErrorImage();
                    TileLoader.this.listener.tileLoadingFinished(this.tile, false);
                }
                return;
            }
            catch (ConnectException e) {
                log.warn("Downloading of " + this.tile + " failed " + e.getMessage());
            }
            catch (DownloadFailedException e) {
                log.warn("Downloading of " + this.tile + " failed " + e.getMessage());
            }
            catch (Exception e) {
                log.debug("Downloading of " + this.tile + " failed", e);
            }
            this.tile.setErrorImage();
            TileLoader.this.listener.tileLoadingFinished(this.tile, false);
        }

        protected boolean loadTileFromStore() {
            try {
                BufferedImage image = this.mapSource.getTileImage(this.zoom, this.tilex, this.tiley, MapSource.LoadMethod.CACHE);
                if (image == null) {
                    return false;
                }
                this.tile.setImage(image);
                TileLoader.this.listener.tileLoadingFinished(this.tile, true);
                if (TileDownLoader.isTileExpired(this.tileStoreEntry)) {
                    return false;
                }
                this.fileTilePainted = true;
                return true;
            }
            catch (Exception e) {
                log.error("Failed to load tile (z=" + this.zoom + ",x=" + this.tilex + ",y=" + this.tiley + ") from tile store", e);
                return false;
            }
        }
    }
}

