/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JComponent;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.Settings;
import mobac.program.model.UnitSystem;
import mobac.utilities.MyMath;

public class ScaleBar {
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private static final Font FONT = new Font("Sans Serif", 0, 12);

    public static void paintScaleBar(JComponent c, Graphics2D g, MapSpace mapSpace, Point tlc, int zoom) {
        Rectangle r = c.getBounds();
        int posY = r.height - r.y;
        int posX = 40;
        int coordY = tlc.y + (posY -= 40);
        int w1 = 150;
        UnitSystem unitSystem = Settings.getInstance().unitSystem;
        double ad = mapSpace.horizontalDistance(zoom, coordY, w1);
        String unit = unitSystem.unitLarge;
        double dist1 = ad * unitSystem.earthRadius;
        if (dist1 < 1.0) {
            dist1 *= (double)unitSystem.unitFactor;
            unit = unitSystem.unitSmall;
        }
        double dist2 = MyMath.prettyRound(dist1);
        double factor = dist2 / dist1;
        int w2 = (int)((double)w1 * factor);
        g.setStroke(STROKE);
        g.setColor(Color.YELLOW);
        g.fillRect(posX, posY - 10, w2, 20);
        g.setColor(Color.BLACK);
        g.drawRect(posX, posY - 10, w2, 20);
        String value = Integer.toString((int)dist2) + " " + unit;
        g.setFont(FONT);
        g.drawString(value, posX + 10, posY + 4);
    }
}

