/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.gpxtree;

import mobac.data.gpx.gpx11.Gpx;
import mobac.data.gpx.gpx11.MetadataType;
import mobac.gui.gpxtree.GpxEntry;
import mobac.gui.mapview.layer.GpxLayer;
import mobac.utilities.I18nUtils;

public class GpxRootEntry
extends GpxEntry {
    public GpxRootEntry(GpxLayer layer) {
        this.setLayer(layer);
        this.setWaypointParent(true);
    }

    public String toString() {
        String name = this.getMetaDataName();
        if (name != null && !name.equals("")) {
            return name;
        }
        if (this.getLayer().getFile() == null) {
            return I18nUtils.localizedStringForKey("rp_gpx_root_default_name_nofile", new Object[0]);
        }
        return String.format(I18nUtils.localizedStringForKey("rp_gpx_root_default_name_hasfile", new Object[0]), this.getLayer().getFile().getName());
    }

    public String getMetaDataName() {
        try {
            return this.getLayer().getGpx().getMetadata().getName();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void setMetaDataName(String name) {
        Gpx gpx = this.getLayer().getGpx();
        if (gpx.getMetadata() == null) {
            gpx.setMetadata(new MetadataType());
        }
        gpx.getMetadata().setName(name);
        this.getLayer().getPanel().getTreeModel().nodeChanged(this.getNode());
    }
}

