/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.dialogs;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.concurrent.ThreadFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

public class WorkinprogressDialog
extends JDialog
implements WindowListener {
    private static final Logger log = Logger.getLogger(WorkinprogressDialog.class);
    private final ThreadFactory threadFactory;
    private Thread workerThread;

    public WorkinprogressDialog(Frame owner, String title, ThreadFactory threadFactory) {
        super(owner, title, true);
        this.threadFactory = threadFactory;
        this.setLayout(new FlowLayout());
        this.add(new JLabel(new ImageIcon(Utilities.getResourceImageUrl("ajax-loader.gif"))));
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(owner);
        this.addWindowListener(this);
        JButton abort = new JButton(I18nUtils.localizedStringForKey("dlg_progress_about_btn", new Object[0]));
        abort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                log.debug("User interrupted process");
                WorkinprogressDialog.this.close();
            }
        });
        this.add(abort);
        this.pack();
    }

    public void startWork(final Runnable r) {
        this.workerThread = this.threadFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    r.run();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
                finally {
                    WorkinprogressDialog.this.close();
                    log.debug("Worker thread finished");
                }
            }
        });
        Thread t1 = new Thread(){

            public void run() {
                WorkinprogressDialog.this.setVisible(true);
            }
        };
        t1.start();
    }

    protected synchronized void abortWorking() {
        try {
            if (this.workerThread != null && !this.workerThread.isInterrupted()) {
                log.debug("User aborted process - interrupting worker thread");
                this.workerThread.interrupt();
                this.workerThread = null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public void close() {
        this.abortWorking();
        this.setVisible(false);
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
        this.workerThread.start();
    }

    public void windowClosed(WindowEvent event) {
        this.abortWorking();
    }

    public void windowClosing(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }
}

