/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mobac.gui.MainGUI;
import mobac.program.model.Bookmark;
import mobac.program.model.Settings;
import mobac.utilities.GBC;
import mobac.utilities.I18nUtils;

public class ManageBookmarks
extends JDialog
implements ActionListener,
ListSelectionListener {
    private JButton deleteButton;
    private JButton applyButton;
    private JList<Bookmark> bookmarks;
    private DefaultListModel<Bookmark> bookmarksModel;

    public ManageBookmarks(Window owner) throws HeadlessException {
        super(owner, I18nUtils.localizedStringForKey("dlg_mgn_bookmark_title", new Object[0]));
        this.setIconImages(MainGUI.MOBAC_ICONS);
        this.setLayout(new GridBagLayout());
        this.applyButton = new JButton(I18nUtils.localizedStringForKey("Close", new Object[0]));
        this.applyButton.addActionListener(this);
        this.applyButton.setDefaultCapable(true);
        this.deleteButton = new JButton(I18nUtils.localizedStringForKey("dlg_mgn_bookmark_delete", new Object[0]));
        this.deleteButton.addActionListener(this);
        this.bookmarksModel = new DefaultListModel();
        for (Bookmark b : Settings.getInstance().placeBookmarks) {
            this.bookmarksModel.addElement(b);
        }
        this.bookmarks = new JList<Bookmark>(this.bookmarksModel);
        this.bookmarks.setSelectionMode(1);
        this.bookmarks.addListSelectionListener(this);
        this.bookmarks.setVisibleRowCount(10);
        this.bookmarks.setPreferredSize(new Dimension(250, 300));
        this.add(this.bookmarks, GBC.eol().insets(10, 10, 10, 10).fill());
        this.add((Component)this.deleteButton, GBC.eol().anchor(10).insets(0, 0, 0, 10));
        this.add((Component)this.applyButton, GBC.eol().anchor(10).insets(0, 0, 0, 10));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getWidth()) / 2, (dim.height - this.getHeight()) / 2);
        this.valueChanged(null);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.deleteButton.equals(e.getSource())) {
            this.deleteSelectedEntries();
        } else if (this.applyButton.equals(e.getSource())) {
            this.apply();
        }
    }

    protected void deleteSelectedEntries() {
        int[] selected = this.bookmarks.getSelectedIndices();
        for (int i = selected.length - 1; i >= 0; --i) {
            this.bookmarksModel.remove(selected[i]);
        }
    }

    protected void apply() {
        ArrayList<Bookmark> bookmarksList = new ArrayList<Bookmark>(this.bookmarksModel.getSize());
        for (int i = 0; i < this.bookmarksModel.getSize(); ++i) {
            bookmarksList.add(this.bookmarksModel.get(i));
        }
        Settings.getInstance().placeBookmarks = bookmarksList;
        this.setVisible(false);
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.deleteButton.setEnabled(this.bookmarks.getSelectedIndices().length > 0);
    }
}

