/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.components;

import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class JTimeSlider
extends JSlider {
    private static final long serialVersionUID = 1L;
    private static final Hashtable<Integer, JLabel> LABEL_TABLE;
    private static final double LOG2;
    private static final double C1;
    private static final double C2;

    public JTimeSlider() {
        super(10000, 31000);
        this.setMinorTickSpacing(1000);
        this.setPaintTicks(true);
        this.setLabelTable(LABEL_TABLE);
        this.setPaintLabels(true);
    }

    public long getTimeSecondsValue() {
        return JTimeSlider.sliderToTimeValue(super.getValue()) / 1000L;
    }

    public long getTimeMilliValue() {
        return JTimeSlider.sliderToTimeValue(super.getValue());
    }

    public void setTimeMilliValue(long time) {
        super.setValue(JTimeSlider.timeToSliderValue(time));
    }

    private static long sliderToTimeValue(int sliderValue) {
        return -1024000L + (long)(1000.0 * Math.pow(2.0, (double)sliderValue / 1000.0));
    }

    private static int timeToSliderValue(long timeValue) {
        return (int)(C1 * (C2 - Math.log((double)(timeValue + 1024000L) / 125.0)));
    }

    static {
        LOG2 = Math.log(2.0);
        C1 = -1000.4 / LOG2;
        C2 = 3.0 * LOG2;
        LABEL_TABLE = new Hashtable();
        int hour = JTimeSlider.timeToSliderValue(TimeUnit.HOURS.toMillis(1L));
        int day = JTimeSlider.timeToSliderValue(TimeUnit.DAYS.toMillis(1L));
        int month = JTimeSlider.timeToSliderValue(TimeUnit.DAYS.toMillis(31L));
        int year = JTimeSlider.timeToSliderValue(TimeUnit.DAYS.toMillis(365L));
        LABEL_TABLE.put(new Integer(10000), new JLabel("0 sec"));
        LABEL_TABLE.put(new Integer(hour), new JLabel("1 hour"));
        LABEL_TABLE.put(new Integer(day), new JLabel("1 day"));
        LABEL_TABLE.put(new Integer(month), new JLabel("1 month"));
        LABEL_TABLE.put(new Integer(year), new JLabel("1 year"));
        LABEL_TABLE.put(new Integer(31000), new JLabel("never"));
    }
}

