/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.atlastree;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mobac.gui.MainGUI;
import mobac.gui.atlastree.DragDropController;
import mobac.gui.atlastree.MouseController;
import mobac.gui.atlastree.NodeEditor;
import mobac.gui.atlastree.NodeRenderer;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.layer.MapAreaHighlightingLayer;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.AtlasObject;
import mobac.program.interfaces.CapabilityDeletable;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.RequiresSQLite;
import mobac.program.interfaces.ToolTipProvider;
import mobac.program.model.Atlas;
import mobac.program.model.AtlasOutputFormat;
import mobac.program.model.AtlasTreeModel;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.MapSelection;
import mobac.program.model.Profile;
import mobac.program.model.TileImageParameters;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.I18nUtils;
import mobac.utilities.jdbc.SQLiteLoader;
import org.apache.log4j.Logger;

public class JAtlasTree
extends JTree
implements Autoscroll {
    private static final long serialVersionUID = 1L;
    private static final String MSG_ATLAS_VERSION_MISMATCH = I18nUtils.localizedStringForKey("msg_atlas_version_mismatch", new Object[0]);
    private static final String MSG_ATLAS_DATA_CHECK_FAILED = I18nUtils.localizedStringForKey("msg_atlas_data_check_failed", new Object[0]);
    private static final String MSG_ATLAS_EMPTY = I18nUtils.localizedStringForKey("msg_atlas_is_empty", new Object[0]);
    private static final Logger log = Logger.getLogger(JAtlasTree.class);
    private AtlasTreeModel treeModel;
    private PreviewMap mapView;
    protected NodeRenderer nodeRenderer;
    protected String defaultToolTiptext;
    protected KeyStroke deleteNodeKS;
    protected DragDropController ddc;
    protected boolean displaySelectedMapArea = false;

    public JAtlasTree(PreviewMap mapView) {
        super(new AtlasTreeModel());
        if (mapView == null) {
            throw new NullPointerException("MapView parameter is null");
        }
        this.mapView = mapView;
        this.getSelectionModel().setSelectionMode(1);
        this.ddc = new DragDropController(this);
        this.treeModel = (AtlasTreeModel)this.getModel();
        this.setShowsRootHandles(true);
        this.nodeRenderer = new NodeRenderer();
        this.setCellRenderer(this.nodeRenderer);
        this.setCellEditor(new NodeEditor(this));
        this.setToolTipText("");
        this.defaultToolTiptext = I18nUtils.localizedStringForKey("lp_atlas_default_tip", new Object[0]);
        this.setAutoscrolls(true);
        this.addMouseListener(new MouseController(this));
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        this.deleteNodeKS = KeyStroke.getKeyStroke(127, 0);
        inputMap.put(this.deleteNodeKS, "DELETE_NODE");
        actionMap.put("DELETE_NODE", new AbstractAction(I18nUtils.localizedStringForKey("lp_atlas_pop_menu_delete_node", new Object[0])){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                JAtlasTree.this.deleteSelectedNode();
                JAtlasTree.this.mapView.repaint();
            }
        });
    }

    public boolean testAtlasContentValid() {
        AtlasInterface atlas = this.getAtlas();
        if (RequiresSQLite.class.isAssignableFrom(atlas.getOutputFormat().getMapCreatorClass()) && !SQLiteLoader.loadSQLiteOrShowError()) {
            return false;
        }
        if (atlas.calculateTilesToDownload() == 0L) {
            JOptionPane.showMessageDialog(null, "<html>" + MSG_ATLAS_EMPTY + "</html>", "Error - atlas has no content", 0);
            return false;
        }
        return true;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.getRowForLocation(event.getX(), event.getY()) == -1) {
            return this.defaultToolTiptext;
        }
        TreePath curPath = this.getPathForLocation(event.getX(), event.getY());
        Object o = curPath.getLastPathComponent();
        if (o == null || !(o instanceof ToolTipProvider)) {
            return null;
        }
        return ((ToolTipProvider)o).getToolTip();
    }

    public boolean isPathEditable(TreePath path) {
        return super.isPathEditable(path) && path.getLastPathComponent() instanceof AtlasObject;
    }

    public AtlasTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void newAtlas(String name, AtlasOutputFormat format) {
        log.debug("Creating new atlas");
        Atlas newAtlas = Atlas.newInstance();
        newAtlas.setOutputFormat(format);
        newAtlas.setName(name);
        this.treeModel.setAtlas(newAtlas);
        this.mapView.repaint();
    }

    public void newAtlas() {
        log.debug("Resetting atlas tree model");
        Atlas newAtlas = Atlas.newInstance();
        newAtlas.setName(MainGUI.getMainGUI().getUserText());
        this.treeModel.setAtlas(newAtlas);
        this.mapView.repaint();
    }

    public void convertAtlas(AtlasOutputFormat format) {
        log.debug("Converting the atlas format to " + format);
        this.treeModel.getAtlas().setOutputFormat(format);
    }

    public void deleteSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return;
        }
        TreeNode selected = (TreeNode)path.getLastPathComponent();
        int[] selectedRows = this.getSelectionRows();
        if (!(selected instanceof CapabilityDeletable)) {
            return;
        }
        this.treeModel.notifyNodeDelete(selected);
        ((CapabilityDeletable)((Object)selected)).delete();
        int selRow = Math.min(selectedRows[0], this.getRowCount() - 1);
        TreePath path1 = path.getParentPath();
        TreePath path2 = this.getPathForRow(selRow).getParentPath();
        if (path1 != path2) {
            this.setSelectionPath(path1);
        } else {
            this.setSelectionRow(selRow);
            this.scrollRowToVisible(selRow);
        }
    }

    public AtlasInterface getAtlas() {
        return this.treeModel.getAtlas();
    }

    public boolean load(Profile profile) {
        log.debug("Loading profile " + profile);
        try {
            Atlas atlas;
            this.treeModel.load(profile);
            if (this.treeModel.getAtlas() instanceof Atlas && (atlas = (Atlas)this.treeModel.getAtlas()).getVersion() < 1) {
                JOptionPane.showMessageDialog(null, MSG_ATLAS_VERSION_MISMATCH, "Outdated atlas version", 2);
                return true;
            }
            boolean problemsDetected = Profile.checkAtlas(this.treeModel.getAtlas());
            if (problemsDetected) {
                JOptionPane.showMessageDialog(null, MSG_ATLAS_DATA_CHECK_FAILED, "Atlas loading problem", 2);
            }
            return true;
        }
        catch (Exception e) {
            GUIExceptionHandler.processException(e);
            return false;
        }
    }

    public boolean save(Profile profile) {
        try {
            this.treeModel.save(profile);
            return true;
        }
        catch (Exception e) {
            GUIExceptionHandler.processException(e);
            return false;
        }
    }

    protected void showNodePopupMenu(MouseEvent event) {
        JPopupMenu pm = new JPopupMenu();
        final TreePath selPath = this.getPathForLocation(event.getX(), event.getY());
        this.setSelectionPath(selPath);
        JMenuItem mi = null;
        if (selPath != null) {
            final Object o = selPath.getLastPathComponent();
            if (o == null) {
                return;
            }
            if (o instanceof ToolTipProvider) {
                mi = new JMenuItem(I18nUtils.localizedStringForKey("lp_atlas_pop_menu_show_detail", new Object[0]));
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ToolTipProvider ttp = (ToolTipProvider)o;
                        JOptionPane.showMessageDialog(MainGUI.getMainGUI(), ttp.getToolTip());
                    }
                });
                pm.add(mi);
            }
            if (o instanceof AtlasObject) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(I18nUtils.localizedStringForKey("lp_atlas_pop_menu_display_select_area", new Object[0]));
                final MapAreaHighlightingLayer msl = new MapAreaHighlightingLayer(this);
                cbmi.setSelected(this.displaySelectedMapArea);
                cbmi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (JAtlasTree.this.displaySelectedMapArea) {
                            MapAreaHighlightingLayer.removeHighlightingLayers();
                        } else {
                            JAtlasTree.this.mapView.setSelectionByTileCoordinate(null, null, false);
                            MapAreaHighlightingLayer.removeHighlightingLayers();
                            ((JAtlasTree)JAtlasTree.this).mapView.mapLayers.add(msl);
                        }
                        JAtlasTree.this.displaySelectedMapArea = !JAtlasTree.this.displaySelectedMapArea;
                        JAtlasTree.this.mapView.repaint();
                    }
                });
                pm.add(cbmi);
            }
            if (o instanceof MapInterface) {
                mi = new JMenuItem(I18nUtils.localizedStringForKey("lp_atlas_pop_menu_select_map_box", new Object[0]));
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MapInterface map = (MapInterface)o;
                        JAtlasTree.this.mapView.setMapSource(map.getMapSource());
                        JAtlasTree.this.mapView.setSelectionByTileCoordinate(map.getZoom(), map.getMinTileCoordinate(), map.getMaxTileCoordinate(), true);
                    }
                });
                pm.add(mi);
                mi = new JMenuItem(I18nUtils.localizedStringForKey("lp_atlas_pop_menu_zoom_to_map_box", new Object[0]));
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MapInterface map = (MapInterface)o;
                        MapSelection ms = new MapSelection(map);
                        JAtlasTree.this.mapView.setMapSource(map.getMapSource());
                        JAtlasTree.this.mapView.setSelectionAndZoomTo(ms, true);
                        JAtlasTree.this.mapView.setSelectionByTileCoordinate(map.getZoom(), map.getMinTileCoordinate(), map.getMaxTileCoordinate(), true);
                    }
                });
                pm.add(mi);
            }
            if (o instanceof LayerInterface) {
                mi = new JMenuItem(I18nUtils.localizedStringForKey("lp_atlas_pop_menu_zoom_to", new Object[0]));
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        LayerInterface layer = (LayerInterface)o;
                        EastNorthCoordinate max = new EastNorthCoordinate(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                        EastNorthCoordinate min = new EastNorthCoordinate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                        for (MapInterface map : layer) {
                            MapSelection ms = new MapSelection(map);
                            EastNorthCoordinate mapMax = ms.getMax();
                            EastNorthCoordinate mapMin = ms.getMin();
                            max.lat = Math.max(max.lat, mapMax.lat);
                            max.lon = Math.max(max.lon, mapMax.lon);
                            min.lat = Math.min(min.lat, mapMin.lat);
                            min.lon = Math.min(min.lon, mapMin.lon);
                        }
                        MapSelection ms = new MapSelection(JAtlasTree.this.mapView.getMapSource(), max, min);
                        JAtlasTree.this.mapView.zoomTo(ms);
                    }
                });
                pm.add(mi);
            }
            if (o instanceof AtlasObject) {
                mi = new JMenuItem(I18nUtils.localizedStringForKey("lp_atlas_pop_menu_rename", new Object[0]));
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JAtlasTree.this.startEditingAtPath(selPath);
                    }
                });
                pm.add(mi);
                mi = new JMenuItem(I18nUtils.localizedStringForKey("lp_atlas_pop_menu_apply_tile_process", new Object[0]));
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        AtlasObject atlasObject = (AtlasObject)o;
                        TileImageParameters p = MainGUI.getMainGUI().getSelectedTileImageParameters();
                        JAtlasTree.this.applyTileImageParameters(atlasObject, p);
                    }
                });
                pm.add(mi);
            }
            if (o instanceof CapabilityDeletable) {
                pm.addSeparator();
                mi = new JMenuItem(this.getActionMap().get("DELETE_NODE"));
                mi.setAccelerator(this.deleteNodeKS);
                pm.add(mi);
            }
        }
        if (pm.getComponentCount() > 0) {
            pm.addSeparator();
        }
        mi = new JMenuItem(I18nUtils.localizedStringForKey("lp_atlas_pop_menu_clear_atals", new Object[0]));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JAtlasTree.this.newAtlas();
            }
        });
        pm.add(mi);
        pm.show(this, event.getX(), event.getY());
    }

    protected void applyTileImageParameters(Object o, TileImageParameters p) {
        if (o instanceof Iterable) {
            Iterable it = (Iterable)o;
            for (Object ao : it) {
                this.applyTileImageParameters(ao, p);
            }
        } else if (o instanceof MapInterface) {
            ((MapInterface)o).setParameters(p);
        }
    }

    protected void selectElementOnMap(Object o) {
        if (o instanceof MapInterface) {
            MapInterface map = (MapInterface)o;
            this.mapView.setMapSource(map.getMapSource());
            this.mapView.setSelectionByTileCoordinate(map.getZoom(), map.getMinTileCoordinate(), map.getMaxTileCoordinate(), true);
        }
    }

    public void autoscroll(Point cursorLocn) {
        int realrow = this.getRowForLocation(cursorLocn.x, cursorLocn.y);
        Rectangle outer = this.getBounds();
        realrow = cursorLocn.y + outer.y <= 12 ? (realrow < 1 ? 0 : realrow - 1) : (realrow < this.getRowCount() - 1 ? realrow + 1 : realrow);
        this.scrollRowToVisible(realrow);
    }

    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + 12, inner.x - outer.x + 12, outer.height - inner.height - inner.y + outer.y + 12, outer.width - inner.width - inner.x + outer.x + 12);
    }
}

