/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.actions;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import mobac.data.gpx.gpx11.Gpx;
import mobac.data.gpx.gpx11.RteType;
import mobac.data.gpx.gpx11.TrkType;
import mobac.data.gpx.gpx11.TrksegType;
import mobac.data.gpx.gpx11.WptType;
import mobac.gui.gpxtree.GpxEntry;
import mobac.gui.gpxtree.RteEntry;
import mobac.gui.gpxtree.TrkEntry;
import mobac.gui.gpxtree.TrksegEntry;

public class GpxEditor {
    private static GpxEditor editor = null;

    public static GpxEditor getInstance() {
        if (editor == null) {
            editor = new GpxEditor();
        }
        return editor;
    }

    public void findRteAndAdd(RteEntry entry, WptType wpt) {
        List<RteType> rtes = entry.getLayer().getGpx().getRte();
        RteType rteParent = entry.getRte();
        for (RteType rte : rtes) {
            if (!rte.equals(rteParent)) continue;
            rte.getRtept().add(wpt);
        }
    }

    public void findTrksegAndAdd(TrksegEntry entry, WptType wpt) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)entry.getNode().getParent();
        TrkEntry trkParent = (TrkEntry)parentNode.getUserObject();
        TrksegType trksegParent = entry.getTrkSeg();
        List<TrksegType> trksegs = trkParent.getTrk().getTrkseg();
        for (TrksegType trkseg : trksegs) {
            if (!trkseg.equals(trksegParent)) continue;
            trkseg.getTrkpt().add(wpt);
        }
    }

    public boolean findWptAndDelete(WptType wpt, GpxEntry gpxEntry) {
        Gpx gpx = gpxEntry.getLayer().getGpx();
        List<WptType> wpts = gpx.getWpt();
        for (WptType currentWpt : wpts) {
            if (!currentWpt.equals(wpt)) continue;
            wpts.remove(currentWpt);
            return true;
        }
        List<TrkType> trks = gpx.getTrk();
        for (TrkType currentTrk : trks) {
            List<TrksegType> trksegs = currentTrk.getTrkseg();
            for (TrksegType currentTrkseg : trksegs) {
                wpts = currentTrkseg.getTrkpt();
                for (WptType currentWpt : wpts) {
                    if (!currentWpt.equals(wpt)) continue;
                    wpts.remove(currentWpt);
                    return true;
                }
            }
        }
        List<RteType> rtes = gpx.getRte();
        for (RteType currentRte : rtes) {
            wpts = currentRte.getRtept();
            for (WptType currentWpt : wpts) {
                if (!currentWpt.equals(wpt)) continue;
                wpts.remove(currentWpt);
                return true;
            }
        }
        return false;
    }
}

