/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.actions;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import mobac.gui.MainGUI;
import mobac.mapsources.MapSourcesManager;
import mobac.program.interfaces.MapSource;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.utilities.I18nUtils;

public class DebugShowMapSourceNames
implements ActionListener {
    public void actionPerformed(ActionEvent e) {
        ArrayList<MapSource> mapSources = new ArrayList<MapSource>(MapSourcesManager.getInstance().getAllAvailableMapSources());
        Collections.sort(mapSources, new Comparator<MapSource>(){

            @Override
            public int compare(MapSource o1, MapSource o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        JFrame dialog = new JFrame(I18nUtils.localizedStringForKey("dlg_show_source_title", new Object[0]));
        dialog.setLocationRelativeTo(MainGUI.getMainGUI());
        dialog.setLocation(100, 40);
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        dScreen.height -= 200;
        dScreen.width = Math.min(dScreen.width - 100, 700);
        dialog.setSize(dScreen);
        dialog.setDefaultCloseOperation(2);
        JTable mapSourcesTable = new JTable(new MapSourcesTableModel(mapSources));
        JScrollPane scroller = new JScrollPane(mapSourcesTable);
        mapSourcesTable.getColumnModel().getColumn(2).setMaxWidth(100);
        dialog.add(scroller);
        dialog.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapSourcesTableModel
    extends AbstractTableModel {
        List<MapSource> mapSources;

        public MapSourcesTableModel(List<MapSource> mapSources) {
            this.mapSources = mapSources;
        }

        @Override
        public int getRowCount() {
            return this.mapSources.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return I18nUtils.localizedStringForKey("dlg_show_source_column_name", new Object[0]);
                }
                case 1: {
                    return I18nUtils.localizedStringForKey("dlg_show_source_column_display_text", new Object[0]);
                }
                case 2: {
                    return I18nUtils.localizedStringForKey("dlg_show_source_column_rev", new Object[0]);
                }
                case 3: {
                    return I18nUtils.localizedStringForKey("dlg_show_source_column_type", new Object[0]);
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MapSource ms = this.mapSources.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ms.getName();
                }
                case 1: {
                    return ms.toString();
                }
                case 2: {
                    MapSourceLoaderInfo li = ms.getLoaderInfo();
                    if (li == null) {
                        return null;
                    }
                    return li.getRevision();
                }
                case 3: {
                    MapSourceLoaderInfo li = ms.getLoaderInfo();
                    if (li == null) {
                        return null;
                    }
                    String s = "";
                    File f = li.getSourceFile();
                    if (f != null) {
                        s = s + f.getName() + " / ";
                    }
                    return s + (Object)((Object)li.getLoaderType());
                }
            }
            return null;
        }
    }
}

