/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.actions;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import mobac.exceptions.InvalidNameException;
import mobac.gui.MainGUI;
import mobac.gui.atlastree.JAtlasTree;
import mobac.gui.mapview.controller.AbstractPolygonSelectionMapController;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.Layer;
import mobac.program.model.MapPolygon;
import mobac.program.model.SelectedZoomLevels;
import mobac.program.model.TileImageParameters;
import mobac.utilities.I18nUtils;

public class AddPolygonMapLayer
implements ActionListener {
    public void actionPerformed(ActionEvent event) {
        MainGUI mg = MainGUI.getMainGUI();
        AbstractPolygonSelectionMapController msc = (AbstractPolygonSelectionMapController)mg.previewMap.getMapSelectionController();
        JAtlasTree jAtlasTree = mg.jAtlasTree;
        String mapNameFmt = "%s %02d";
        AtlasInterface atlasInterface = jAtlasTree.getAtlas();
        String name = mg.getUserText();
        MapSource mapSource = mg.getSelectedMapSource();
        MapSpace mapSpace = mapSource.getMapSpace();
        SelectedZoomLevels sZL = mg.getSelectedZoomLevels();
        int[] zoomLevels = sZL.getZoomLevels();
        if (zoomLevels.length == 0) {
            JOptionPane.showMessageDialog(mg, I18nUtils.localizedStringForKey("msg_no_zoom_level_selected", new Object[0]));
            return;
        }
        String layerName = name;
        Layer layer = null;
        int c = 1;
        boolean success = false;
        do {
            try {
                layer = new Layer(atlasInterface, layerName);
                success = true;
            }
            catch (InvalidNameException e) {
                layerName = name + "_" + Integer.toString(c++);
            }
        } while (!success);
        ArrayList<Point> polygonPoints = msc.getPolygonPoints();
        for (int zoom : zoomLevels) {
            int[] xpoints = new int[polygonPoints.size()];
            int[] ypoints = new int[polygonPoints.size()];
            for (int i = 0; i < xpoints.length; ++i) {
                Point p = mapSpace.changeZoom((Point)polygonPoints.get(i), 22, zoom);
                xpoints[i] = p.x;
                ypoints[i] = p.y;
            }
            TileImageParameters customTileParameters = mg.getSelectedTileImageParameters();
            Polygon polygon = new Polygon(xpoints, ypoints, xpoints.length);
            String mapName = String.format("%s %02d", layerName, zoom);
            MapPolygon map = new MapPolygon(layer, mapName, mapSource, zoom, polygon, customTileParameters);
            layer.addMap(map);
        }
        atlasInterface.addLayer(layer);
        jAtlasTree.getTreeModel().notifyNodeInsert(layer);
        msc.finishPolygon();
    }
}

