/*
 * Decompiled with CFR 0.152.
 */
package mobac.externaltools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import mobac.externaltools.ToolParameters;
import mobac.gui.MainGUI;
import mobac.program.model.MapSelection;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.I18nUtils;
import org.apache.log4j.Logger;

@XmlRootElement(name="ExternalTool")
public class ExternalToolDef
implements ActionListener {
    private static final Logger log = Logger.getLogger(ExternalToolDef.class);
    public String name;
    public String command;
    public boolean debug = false;
    @XmlList
    public List<ToolParameters> parameters = new ArrayList<ToolParameters>();

    private boolean mapSelNull(MapSelection mapSel) {
        if (mapSel != null) {
            return false;
        }
        JOptionPane.showMessageDialog(MainGUI.getMainGUI(), I18nUtils.localizedStringForKey("msg_tools_exec_error_selected_area", new Object[0]), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            int r;
            String executeCommand = this.command;
            MainGUI gui = MainGUI.getMainGUI();
            MapSelection mapSel = gui.getMapSelectionCoordinates();
            int[] zooms = gui.getSelectedZoomLevels().getZoomLevels();
            for (ToolParameters param : this.parameters) {
                String add = "";
                switch (param) {
                    case MAX_LAT: {
                        if (this.mapSelNull(mapSel)) {
                            return;
                        }
                        add = Double.toString(mapSel.getMax().lat);
                        break;
                    }
                    case MIN_LAT: {
                        if (this.mapSelNull(mapSel)) {
                            return;
                        }
                        add = Double.toString(mapSel.getMin().lat);
                        break;
                    }
                    case MAX_LON: {
                        if (this.mapSelNull(mapSel)) {
                            return;
                        }
                        add = Double.toString(mapSel.getMax().lon);
                        break;
                    }
                    case MIN_LON: {
                        if (this.mapSelNull(mapSel)) {
                            return;
                        }
                        add = Double.toString(mapSel.getMin().lon);
                        break;
                    }
                    case MAX_ZOOM: {
                        if (zooms.length == 0) {
                            JOptionPane.showMessageDialog(gui, I18nUtils.localizedStringForKey("msg_no_zoom_level_selected", new Object[0]), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
                            return;
                        }
                        add = Integer.toString(zooms[zooms.length - 1]);
                        break;
                    }
                    case MIN_ZOOM: {
                        if (zooms.length == 0) {
                            JOptionPane.showMessageDialog(gui, I18nUtils.localizedStringForKey("msg_no_zoom_level_selected", new Object[0]), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
                            return;
                        }
                        add = Integer.toString(zooms[0]);
                        break;
                    }
                    case MAPSOURCE_NAME: {
                        add = gui.previewMap.getMapSource().getName();
                        break;
                    }
                    case MAPSOURCE_DISPLAYNAME: {
                        add = gui.previewMap.getMapSource().toString();
                        break;
                    }
                    case NAME_EDITBOX: {
                        add = gui.getUserText();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported parameter type: " + (Object)((Object)param));
                    }
                }
                if (add.indexOf(32) >= 0) {
                    add = "\"" + add + "\"";
                }
                executeCommand = executeCommand + " " + add;
            }
            if (this.debug && (r = JOptionPane.showConfirmDialog(gui, String.format(I18nUtils.localizedStringForKey("msg_tools_exec_command_ask", new Object[0]), executeCommand), I18nUtils.localizedStringForKey("msg_tools_exec_command_ask_title", new Object[0]), 2)) != 0) {
                return;
            }
            log.debug("Executing " + executeCommand);
            Runtime.getRuntime().exec(executeCommand);
        }
        catch (Exception e1) {
            GUIExceptionHandler.processException(e1);
        }
    }
}

