/*
 * Decompiled with CFR 0.152.
 */
package mobac.exceptions;

import java.io.StringWriter;
import mobac.program.interfaces.ExceptionExtendedInfo;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.MapSourceLoaderInfo;

public class MapCreationException
extends Exception
implements ExceptionExtendedInfo {
    private static final long serialVersionUID = 1L;
    private MapInterface map;

    public MapCreationException(String message, MapInterface map, Throwable cause) {
        super(message, cause);
        this.map = map;
    }

    public MapCreationException(String message, MapInterface map) {
        super(message);
        this.map = map;
    }

    public MapCreationException(MapInterface map, Throwable cause) {
        super(cause);
        this.map = map;
    }

    public String getExtendedInfo() {
        StringWriter sw = new StringWriter();
        if (this.map != null) {
            MapSourceLoaderInfo loaderInfo;
            sw.append(this.map.getInfoText());
            MapSource mapSource = this.map.getMapSource();
            if (mapSource != null && (loaderInfo = this.map.getMapSource().getLoaderInfo()) != null) {
                sw.append("\nMap type: " + (Object)((Object)loaderInfo.getLoaderType()));
                if (loaderInfo.getSourceFile() != null) {
                    sw.append("\nMap implementation: " + loaderInfo.getSourceFile().getName());
                }
                sw.append("\nMap revision: " + loaderInfo.getRevision());
            }
        }
        return sw.toString();
    }

    public MapInterface getMap() {
        return this.map;
    }
}

