/*
 * Decompiled with CFR 0.152.
 */
package mobac;

import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import mobac.StartMOBAC;
import mobac.gui.MainGUI;
import mobac.gui.SplashFrame;
import mobac.mapsources.DefaultMapSourcesManager;
import mobac.program.DirectoryManager;
import mobac.program.EnvironmentSetup;
import mobac.program.Logging;
import mobac.program.ProgramInfo;
import mobac.program.commandline.CommandLineEmpty;
import mobac.program.commandline.CreateAtlas;
import mobac.program.interfaces.CommandLineAction;
import mobac.program.model.Settings;
import mobac.program.tilestore.TileStore;
import mobac.utilities.GUIExceptionHandler;

public class Main {
    protected CommandLineAction cmdAction = new CommandLineEmpty();

    public Main() {
        try {
            this.parseCommandLine();
            if (this.cmdAction.showSplashScreen()) {
                SplashFrame.showFrame();
            }
            DirectoryManager.initialize();
            Logging.configureLogging();
            ProgramInfo.initialize();
            Logging.logSystemInfo();
            GUIExceptionHandler.installToolkitEventQueueProxy();
            ImageIO.setUseCache(false);
            EnvironmentSetup.checkFileSetup();
            Settings.loadOrQuit();
            EnvironmentSetup.checkMemory();
            EnvironmentSetup.copyMapPacks();
            DefaultMapSourcesManager.initialize();
            EnvironmentSetup.createDefaultAtlases();
            TileStore.initialize();
            EnvironmentSetup.upgrade();
            this.cmdAction.runBeforeMainGUI();
            if (this.cmdAction.showMainGUI()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Logging.LOG.debug("Starting GUI");
                        MainGUI.createMainGui();
                        SplashFrame.hideFrame();
                        Main.this.cmdAction.runMainGUI();
                    }
                });
            }
        }
        catch (Throwable t) {
            GUIExceptionHandler.processException(t);
            System.exit(1);
        }
    }

    protected void parseCommandLine() {
        String[] args = StartMOBAC.ARGS;
        if (args.length >= 2 && "create".equalsIgnoreCase(args[0])) {
            this.cmdAction = args.length > 2 ? new CreateAtlas(args[1], args[2]) : new CreateAtlas(args[1]);
            return;
        }
    }
}

