/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.persist.BasicIterator;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.ValueAdapter;
import com.sleepycat.util.keyrange.RangeCursor;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicCursor<V>
implements EntityCursor<V> {
    RangeCursor cursor;
    ValueAdapter<V> adapter;
    boolean updateAllowed;
    DatabaseEntry key;
    DatabaseEntry pkey;
    DatabaseEntry data;

    BasicCursor(RangeCursor cursor, ValueAdapter<V> adapter, boolean updateAllowed) {
        this.cursor = cursor;
        this.adapter = adapter;
        this.updateAllowed = updateAllowed;
        this.key = adapter.initKey();
        this.pkey = adapter.initPKey();
        this.data = adapter.initData();
    }

    @Override
    public V next() throws DatabaseException {
        return this.next(null);
    }

    @Override
    public V next(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getNext(this.key, this.pkey, this.data, lockMode));
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    public Iterator<V> iterator(LockMode lockMode) {
        return new BasicIterator(this, lockMode);
    }

    @Override
    public boolean delete() throws DatabaseException {
        this.checkInitialized();
        return this.cursor.delete() == OperationStatus.SUCCESS;
    }

    @Override
    public void close() throws DatabaseException {
        this.cursor.close();
    }

    void checkInitialized() throws IllegalStateException {
        if (!this.cursor.isInitialized()) {
            throw new IllegalStateException("Cursor is not initialized at a valid position");
        }
    }

    V returnValue(OperationStatus status) {
        V value = status == OperationStatus.SUCCESS ? (V)this.adapter.entryToValue(this.key, this.pkey, this.data) : null;
        this.adapter.clearEntries(this.key, this.pkey, this.data);
        return value;
    }
}

