/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLSN
implements Loggable,
Comparable<VLSN> {
    public static final VLSN NULL_VLSN = new VLSN(-1L);
    public static final VLSN FIRST_VLSN = new VLSN(1L);
    private long sequence;

    public VLSN(long sequence) {
        this.sequence = sequence;
    }

    public VLSN() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VLSN)) {
            return false;
        }
        VLSN otherVLSN = (VLSN)obj;
        return otherVLSN.sequence == this.sequence;
    }

    public int hashCode() {
        return Long.valueOf(this.sequence).hashCode();
    }

    public long getSequence() {
        return this.sequence;
    }

    @Override
    public int compareTo(VLSN other) {
        if (this == NULL_VLSN && other == NULL_VLSN) {
            return 0;
        }
        if (this == NULL_VLSN) {
            return -1;
        }
        if (other == NULL_VLSN) {
            return 1;
        }
        long otherSequence = other.getSequence();
        if (this.sequence - otherSequence > 0L) {
            return 1;
        }
        if (this.sequence == otherSequence) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getLogSize() {
        return 8;
    }

    @Override
    public void writeToLog(ByteBuffer buffer) {
        buffer.putLong(this.sequence);
    }

    @Override
    public void readFromLog(ByteBuffer buffer, byte entryVersion) throws LogException {
        this.sequence = buffer.getLong();
    }

    @Override
    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<vlsn v=\"").append(this).append("\">");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.sequence);
        return sb.toString();
    }
}

