/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.util.HashMap;
import java.util.Map;

public class FileMapper {
    private long fileNumber;
    private VLSN lastSyncVLSN;
    private VLSN lastCommitVLSN;
    private Map<Long, Long> vlsnToFileOffsetMap;
    private boolean dirty;

    public FileMapper(long fileNumber) {
        this.fileNumber = fileNumber;
        this.vlsnToFileOffsetMap = new HashMap<Long, Long>();
        this.lastSyncVLSN = VLSN.NULL_VLSN;
        this.lastCommitVLSN = VLSN.NULL_VLSN;
    }

    private FileMapper() {
    }

    public void putLSN(long vlsn, long lsn, LogEntryType entryType) {
        VLSN thisVLSN;
        assert (DbLsn.getFileNumber(lsn) == this.fileNumber) : "unexpected lsn file num=" + DbLsn.getFileNumber(lsn) + " while file mapper file number=" + this.fileNumber;
        this.vlsnToFileOffsetMap.put(vlsn, DbLsn.getFileOffset(lsn));
        if (entryType.isSyncPoint() && this.lastSyncVLSN.compareTo(thisVLSN = new VLSN(vlsn)) < 0) {
            this.lastSyncVLSN = thisVLSN;
        }
        if (LogEntryType.LOG_TXN_COMMIT.equals(entryType) && this.lastCommitVLSN.compareTo(thisVLSN = new VLSN(vlsn)) < 0) {
            this.lastCommitVLSN = thisVLSN;
        }
        this.dirty = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<FileMapper fileNumber=");
        sb.append(this.fileNumber).append(" ");
        sb.append(" lastSync=").append(this.lastSyncVLSN).append(" ");
        sb.append(" lastCommit=").append(this.lastCommitVLSN).append(" ");
        sb.append(this.vlsnToFileOffsetMap);
        sb.append("/>");
        return sb.toString();
    }
}

