/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.RangeRestartException;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ThinLockImpl;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LockManager
implements EnvConfigObserver {
    static final long TOTAL_LOCKIMPL_OVERHEAD = MemoryBudget.LOCKIMPL_OVERHEAD + MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.LONG_OVERHEAD;
    static final long TOTAL_THINLOCKIMPL_OVERHEAD = MemoryBudget.THINLOCKIMPL_OVERHEAD + MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.LONG_OVERHEAD;
    private static final long REMOVE_TOTAL_LOCKIMPL_OVERHEAD = 0L - TOTAL_LOCKIMPL_OVERHEAD;
    private static final long REMOVE_TOTAL_THINLOCKIMPL_OVERHEAD = 0L - TOTAL_THINLOCKIMPL_OVERHEAD;
    private static final long THINLOCK_MUTATE_OVERHEAD = MemoryBudget.LOCKIMPL_OVERHEAD - MemoryBudget.THINLOCKIMPL_OVERHEAD + MemoryBudget.LOCKINFO_OVERHEAD;
    protected int nLockTables = 1;
    protected Latch[] lockTableLatches;
    private Map<Long, Lock>[] lockTables;
    private EnvironmentImpl envImpl;
    private MemoryBudget memoryBudget;
    private long nRequests;
    private long nWaits;
    private static RangeRestartException rangeRestartException = new RangeRestartException();
    private static boolean lockTableDump = false;

    public LockManager(EnvironmentImpl envImpl) throws DatabaseException {
        DbConfigManager configMgr = envImpl.getConfigManager();
        this.nLockTables = configMgr.getInt(EnvironmentParams.N_LOCK_TABLES);
        this.lockTables = new Map[this.nLockTables];
        this.lockTableLatches = new Latch[this.nLockTables];
        for (int i = 0; i < this.nLockTables; ++i) {
            this.lockTables[i] = new HashMap<Long, Lock>();
            this.lockTableLatches[i] = new Latch("Lock Table " + i);
        }
        this.envImpl = envImpl;
        this.memoryBudget = envImpl.getMemoryBudget();
        this.nRequests = 0L;
        this.nWaits = 0L;
        this.envConfigUpdate(configMgr, null);
        envImpl.addConfigObserver(this);
    }

    public void envConfigUpdate(DbConfigManager configMgr, EnvironmentMutableConfig ignore) throws DatabaseException {
        LockInfo.setDeadlockStackTrace(configMgr.getBoolean(EnvironmentParams.TXN_DEADLOCK_STACK_TRACE));
        LockManager.setLockTableDump(configMgr.getBoolean(EnvironmentParams.TXN_DUMPLOCKS));
    }

    static void setLockTableDump(boolean enable) {
        lockTableDump = enable;
    }

    protected int getLockTableIndex(Long nodeId) {
        return ((int)nodeId.longValue() & Integer.MAX_VALUE) % this.nLockTables;
    }

    protected int getLockTableIndex(long nodeId) {
        return ((int)nodeId & Integer.MAX_VALUE) % this.nLockTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockGrantType lock(long nodeId, Locker locker, LockType type, long timeout, boolean nonBlockingRequest, DatabaseImpl database) throws DeadlockException, DatabaseException {
        assert (timeout >= 0L);
        Locker locker2 = locker;
        synchronized (locker2) {
            Long nid = nodeId;
            LockAttemptResult result = this.attemptLock(nid, locker, type, nonBlockingRequest);
            if (result.success || result.lockGrant == LockGrantType.DENIED) {
                return result.lockGrant;
            }
            assert (this.checkNoLatchesHeld(nonBlockingRequest)) : LatchSupport.countLatchesHeld() + " latches held while trying to lock, lock table =" + LatchSupport.latchesHeldToString();
            assert (!nonBlockingRequest);
            try {
                long startTime;
                boolean doWait = true;
                if (locker.isTimedOut()) {
                    if (this.validateOwnership(nid, locker, type, true, this.memoryBudget)) {
                        doWait = false;
                    } else {
                        DeadlockException DE = this.makeTimeoutMsg("Transaction", locker, nodeId, type, result.lockGrant, result.useLock, locker.getTxnTimeout(), locker.getTxnStartMillis(), System.currentTimeMillis(), database);
                        throw DE;
                    }
                }
                boolean keepTime = timeout > 0L;
                long l = startTime = keepTime ? System.currentTimeMillis() : 0L;
                while (doWait) {
                    locker.setWaitingFor(result.useLock);
                    try {
                        locker.wait(timeout);
                    }
                    catch (InterruptedException IE) {
                        throw new RunRecoveryException(this.envImpl, (Throwable)IE);
                    }
                    boolean lockerTimedOut = locker.isTimedOut();
                    long now = System.currentTimeMillis();
                    boolean thisLockTimedOut = keepTime && now - startTime >= timeout;
                    boolean isRestart = result.lockGrant == LockGrantType.WAIT_RESTART;
                    if (this.validateOwnership(nid, locker, type, lockerTimedOut || thisLockTimedOut || isRestart, this.memoryBudget)) {
                        break;
                    }
                    if (isRestart) {
                        throw rangeRestartException;
                    }
                    if (thisLockTimedOut) {
                        locker.setOnlyAbortable();
                        DeadlockException DE = this.makeTimeoutMsg("Lock", locker, nodeId, type, result.lockGrant, result.useLock, timeout, startTime, now, database);
                        throw DE;
                    }
                    if (!lockerTimedOut) continue;
                    locker.setOnlyAbortable();
                    DeadlockException DE = this.makeTimeoutMsg("Transaction", locker, nodeId, type, result.lockGrant, result.useLock, locker.getTxnTimeout(), locker.getTxnStartMillis(), now, database);
                    throw DE;
                }
            }
            finally {
                locker.setWaitingFor(null);
                assert (EnvironmentImpl.maybeForceYield());
            }
            locker.addLock(nid, type, result.lockGrant);
            return result.lockGrant;
        }
    }

    protected abstract LockAttemptResult attemptLock(Long var1, Locker var2, LockType var3, boolean var4) throws DatabaseException;

    protected LockAttemptResult attemptLockInternal(Long nodeId, Locker locker, LockType type, boolean nonBlockingRequest, int lockTableIndex) throws DatabaseException {
        ++this.nRequests;
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        if (useLock == null) {
            useLock = new ThinLockImpl();
            lockTable.put(nodeId, useLock);
            this.memoryBudget.updateLockMemoryUsage(TOTAL_THINLOCKIMPL_OVERHEAD, lockTableIndex);
        }
        LockAttemptResult lar = useLock.lock(type, locker, nonBlockingRequest, this.memoryBudget, lockTableIndex);
        if (lar.useLock != useLock) {
            useLock = lar.useLock;
            lockTable.put(nodeId, useLock);
            this.memoryBudget.updateLockMemoryUsage(THINLOCK_MUTATE_OVERHEAD, lockTableIndex);
        }
        LockGrantType lockGrant = lar.lockGrant;
        boolean success = false;
        if (lockGrant == LockGrantType.NEW || lockGrant == LockGrantType.PROMOTION) {
            locker.addLock(nodeId, type, lockGrant);
            success = true;
        } else if (lockGrant == LockGrantType.EXISTING) {
            success = true;
        } else if (lockGrant != LockGrantType.DENIED) {
            ++this.nWaits;
        }
        return new LockAttemptResult(useLock, lockGrant, success);
    }

    protected abstract DeadlockException makeTimeoutMsg(String var1, Locker var2, long var3, LockType var5, LockGrantType var6, Lock var7, long var8, long var10, long var12, DatabaseImpl var14) throws DatabaseException;

    protected DeadlockException makeTimeoutMsgInternal(String lockOrTxn, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database) {
        if (lockTableDump) {
            System.out.println("++++++++++ begin lock table dump ++++++++++");
            for (int i = 0; i < this.nLockTables; ++i) {
                boolean success = false;
                for (int j = 0; j < 3 && !success; ++j) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        this.dumpToStringNoLatch(sb, i);
                        System.out.println(sb.toString());
                        success = true;
                        break;
                    }
                    catch (ConcurrentModificationException CME) {
                        continue;
                    }
                }
                if (success) continue;
                System.out.println("Couldn't dump locktable " + i);
            }
            System.out.println("++++++++++ end lock table dump ++++++++++");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(lockOrTxn);
        sb.append(" expired. Locker ").append(locker);
        sb.append(": waited for lock");
        if (database != null) {
            sb.append(" on database=").append(database.getDebugName());
        }
        sb.append(" LockAddr:").append(System.identityHashCode(useLock));
        sb.append(" node=").append(nodeId);
        sb.append(" type=").append(type);
        sb.append(" grant=").append(grantType);
        sb.append(" timeoutMillis=").append(timeout);
        sb.append(" startTime=").append(start);
        sb.append(" endTime=").append(now);
        Set<LockInfo> owners = useLock.getOwnersClone();
        List<LockInfo> waiters = useLock.getWaitersListClone();
        sb.append("\nOwners: ").append(owners);
        sb.append("\nWaiters: ").append(waiters).append("\n");
        StringBuilder deadlockInfo = this.findDeadlock(useLock, locker);
        if (deadlockInfo != null) {
            sb.append((CharSequence)deadlockInfo);
        }
        DeadlockException ret = new DeadlockException(sb.toString());
        ret.setOwnerTxnIds(this.getTxnIds(owners));
        ret.setWaiterTxnIds(this.getTxnIds(waiters));
        ret.setTimeoutMillis(timeout);
        return ret;
    }

    private long[] getTxnIds(Collection<LockInfo> c) {
        long[] ret = new long[c.size()];
        Iterator<LockInfo> iter = c.iterator();
        int i = 0;
        while (iter.hasNext()) {
            LockInfo info = iter.next();
            ret[i++] = info.getLocker().getId();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(long nodeId, Locker locker) throws DatabaseException {
        Locker locker2 = locker;
        synchronized (locker2) {
            Set<Locker> newOwners = this.releaseAndFindNotifyTargets(nodeId, locker);
            if (newOwners == null) {
                return false;
            }
            if (newOwners.size() > 0) {
                Iterator<Locker> iter = newOwners.iterator();
                while (iter.hasNext()) {
                    Locker lockerToNotify;
                    Locker locker3 = lockerToNotify = iter.next();
                    synchronized (locker3) {
                        lockerToNotify.notifyAll();
                    }
                    assert (EnvironmentImpl.maybeForceYield());
                }
            }
            return true;
        }
    }

    protected abstract Set<Locker> releaseAndFindNotifyTargets(long var1, Locker var3) throws DatabaseException;

    protected Set<Locker> releaseAndFindNotifyTargetsInternal(long nodeId, Locker locker, int lockTableIndex) throws DatabaseException {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        if (useLock == null) {
            useLock = lockTable.get(nodeId);
        }
        if (useLock == null) {
            return null;
        }
        Set<Locker> lockersToNotify = useLock.release(locker, this.memoryBudget, lockTableIndex);
        if (lockersToNotify == null) {
            return null;
        }
        if (useLock.nWaiters() == 0 && useLock.nOwners() == 0) {
            this.lockTables[lockTableIndex].remove(nodeId);
            if (useLock.isThin()) {
                this.memoryBudget.updateLockMemoryUsage(REMOVE_TOTAL_THINLOCKIMPL_OVERHEAD, lockTableIndex);
            } else {
                this.memoryBudget.updateLockMemoryUsage(REMOVE_TOTAL_LOCKIMPL_OVERHEAD, lockTableIndex);
            }
        }
        return lockersToNotify;
    }

    abstract void transfer(long var1, Locker var3, Locker var4, boolean var5) throws DatabaseException;

    protected void transferInternal(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead, int lockTableIndex) throws DatabaseException {
        Lock newLock;
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        assert (useLock != null) : "Transfer, lock " + nodeId + " was null";
        if (demoteToRead) {
            useLock.demote(owningLocker);
        }
        if ((newLock = useLock.transfer(nodeId, owningLocker, destLocker, this.memoryBudget, lockTableIndex)) != useLock) {
            lockTable.put(nodeId, newLock);
            this.memoryBudget.updateLockMemoryUsage(THINLOCK_MUTATE_OVERHEAD, lockTableIndex);
        }
        owningLocker.removeLock(nodeId);
    }

    abstract void transferMultiple(long var1, Locker var3, Locker[] var4) throws DatabaseException;

    protected void transferMultipleInternal(long nodeId, Locker owningLocker, Locker[] destLockers, int lockTableIndex) throws DatabaseException {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        assert (useLock != null) : "Transfer, lock " + nodeId + " was null";
        useLock.demote(owningLocker);
        Lock newLock = useLock.transferMultiple(nodeId, owningLocker, destLockers, this.memoryBudget, lockTableIndex);
        if (newLock != useLock) {
            lockTable.put(nodeId, newLock);
            this.memoryBudget.updateLockMemoryUsage(THINLOCK_MUTATE_OVERHEAD, lockTableIndex);
        }
        owningLocker.removeLock(nodeId);
    }

    abstract void demote(long var1, Locker var3) throws DatabaseException;

    protected void demoteInternal(long nodeId, Locker locker, int lockTableIndex) throws DatabaseException {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        useLock.demote(locker);
        locker.moveWriteToReadLock(nodeId, useLock);
    }

    protected boolean isOwnerInternal(Long nodeId, Locker locker, LockType type, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.isOwner(locker, type);
    }

    protected abstract boolean validateOwnership(Long var1, Locker var2, LockType var3, boolean var4, MemoryBudget var5) throws DatabaseException;

    protected boolean validateOwnershipInternal(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb, int lockTableIndex) throws DatabaseException {
        Lock entry;
        if (this.isOwnerInternal(nodeId, locker, type, lockTableIndex)) {
            return true;
        }
        if (flushFromWaiters && (entry = this.lockTables[lockTableIndex].get(nodeId)) != null) {
            entry.flushWaiter(locker, mb, lockTableIndex);
        }
        return false;
    }

    public LockStats lockStat(StatsConfig config) throws DatabaseException {
        LockStats stats = new LockStats();
        stats.setNRequests(this.nRequests);
        stats.setNWaits(this.nWaits);
        if (config.getClear()) {
            this.nWaits = 0L;
            this.nRequests = 0L;
        }
        for (int i = 0; i < this.nLockTables; ++i) {
            LatchStats latchStats = this.lockTableLatches[i].getLatchStats();
            stats.accumulateLockTableLatchStats(latchStats);
        }
        if (!config.getFast()) {
            this.dumpLockTable(stats);
        }
        return stats;
    }

    protected abstract void dumpLockTable(LockStats var1) throws DatabaseException;

    protected void dumpLockTableInternal(LockStats stats, int i) {
        Map<Long, Lock> lockTable = this.lockTables[i];
        stats.accumulateNTotalLocks(lockTable.size());
        for (Lock lock : lockTable.values()) {
            stats.setNWaiters(stats.getNWaiters() + lock.nWaiters());
            stats.setNOwners(stats.getNOwners() + lock.nOwners());
            for (LockInfo info : lock.getOwnersClone()) {
                if (info.getLockType().isWriteLock()) {
                    stats.setNWriteLocks(stats.getNWriteLocks() + 1);
                    continue;
                }
                stats.setNReadLocks(stats.getNReadLocks() + 1);
            }
        }
    }

    public void dump() throws DatabaseException {
        System.out.println(this.dumpToString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpToString() throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nLockTables; ++i) {
            this.lockTableLatches[i].acquire();
            try {
                this.dumpToStringNoLatch(sb, i);
                continue;
            }
            finally {
                this.lockTableLatches[i].release();
            }
        }
        return sb.toString();
    }

    private void dumpToStringNoLatch(StringBuilder sb, int whichTable) {
        Map<Long, Lock> lockTable = this.lockTables[whichTable];
        for (Map.Entry<Long, Lock> entry : lockTable.entrySet()) {
            Long nid = entry.getKey();
            Lock lock = entry.getValue();
            sb.append("---- Node Id: ").append(nid).append("----\n");
            sb.append(lock);
            sb.append('\n');
        }
    }

    private boolean checkNoLatchesHeld(boolean nonBlockingRequest) {
        if (nonBlockingRequest) {
            return true;
        }
        return LatchSupport.countLatchesHeld() == 0;
    }

    private StringBuilder findDeadlock(Lock lock, Locker rootLocker) {
        HashSet<Locker> ownerSet = new HashSet<Locker>();
        ownerSet.add(rootLocker);
        StringBuilder ret = this.findDeadlock1(ownerSet, lock, rootLocker);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private StringBuilder findDeadlock1(Set<Locker> ownerSet, Lock lock, Locker rootLocker) {
        for (LockInfo info : lock.getOwnersClone()) {
            Locker locker = info.getLocker();
            Lock waitsFor = locker.getWaitingFor();
            if (ownerSet.contains(locker) || locker == rootLocker) {
                StringBuilder ret = new StringBuilder();
                ret.append("Transaction ").append(locker.toString());
                ret.append(" owns LockAddr:").append(System.identityHashCode(lock));
                ret.append(" ").append(info).append("\n");
                ret.append("Transaction ").append(locker.toString());
                ret.append(" waits for");
                if (waitsFor == null) {
                    ret.append(" nothing");
                } else {
                    ret.append(" LockAddr:");
                    ret.append(System.identityHashCode(waitsFor));
                }
                ret.append("\n");
                return ret;
            }
            if (waitsFor == null) continue;
            ownerSet.add(locker);
            StringBuilder sb = this.findDeadlock1(ownerSet, waitsFor, rootLocker);
            if (sb != null) {
                String waitInfo = "Transaction " + locker + " waits for " + waitsFor + "\n";
                sb.insert(0, waitInfo);
                return sb;
            }
            ownerSet.remove(locker);
        }
        return null;
    }
}

