/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogContext;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogManager;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatchedLogManager
extends LogManager {
    public LatchedLogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        super(envImpl, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void serialLog(LogItem[] itemArray, LogContext context) throws IOException, DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.serialLogInternal(itemArray, context);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.logWriteLatch.release();
            throw throwable;
        }
        this.logWriteLatch.release();
    }

    @Override
    protected void flushInternal() throws LogException, DatabaseException {
        this.logWriteLatch.acquire();
        try {
            try {
                this.logBufferPool.writeBufferToFile(0);
            }
            catch (IOException e) {
                throw new LogException(e.getMessage());
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.logWriteLatch.release();
            throw throwable;
        }
        this.logWriteLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackedFileSummary getUnflushableTrackedSummary(long file) throws DatabaseException {
        TrackedFileSummary trackedFileSummary;
        this.logWriteLatch.acquire();
        try {
            trackedFileSummary = this.getUnflushableTrackedSummaryInternal(file);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.logWriteLatch.release();
            throw throwable;
        }
        this.logWriteLatch.release();
        return trackedFileSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTrackedFile(TrackedFileSummary tfs) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.removeTrackedFileInternal(tfs);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.logWriteLatch.release();
            throw throwable;
        }
        this.logWriteLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteNode(long lsn, LogEntryType type, int size, DatabaseImpl nodeDb) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.countObsoleteNodeInternal(lsn, type, size, nodeDb);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.logWriteLatch.release();
            throw throwable;
        }
        this.logWriteLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferToUtilizationTracker(LocalUtilizationTracker localTracker) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.transferToUtilizationTrackerInternal(localTracker);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.logWriteLatch.release();
            throw throwable;
        }
        this.logWriteLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteINs(List<Long> lsnList, DatabaseImpl nodeDb) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.countObsoleteINsInternal(lsnList, nodeDb);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.logWriteLatch.release();
            throw throwable;
        }
        this.logWriteLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteDb(DatabaseImpl db) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.countObsoleteDbInternal(db);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.logWriteLatch.release();
            throw throwable;
        }
        this.logWriteLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDbFileSummary(DatabaseImpl db, Long fileNum) throws DatabaseException {
        boolean bl;
        this.logWriteLatch.acquire();
        try {
            bl = this.removeDbFileSummaryInternal(db, fileNum);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.logWriteLatch.release();
            throw throwable;
        }
        this.logWriteLatch.release();
        return bl;
    }
}

