/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Calendar;

public class FileHeader
implements Loggable {
    private long fileNum;
    private long lastEntryInPrevFileOffset;
    private Timestamp time;
    private int logVersion;

    FileHeader(long fileNum, long lastEntryInPrevFileOffset) {
        this.fileNum = fileNum;
        this.lastEntryInPrevFileOffset = lastEntryInPrevFileOffset;
        Calendar now = Calendar.getInstance();
        this.time = new Timestamp(now.getTimeInMillis());
        this.logVersion = 6;
    }

    public FileHeader() {
    }

    public int getLogVersion() {
        return this.logVersion;
    }

    int validate(String fileName, long expectedFileNum) throws DatabaseException {
        if (this.fileNum != expectedFileNum) {
            throw new LogException("Wrong filenum in header for file " + fileName + " expected " + expectedFileNum + " got " + this.fileNum);
        }
        return this.logVersion;
    }

    long getLastEntryInPrevFileOffset() {
        return this.lastEntryInPrevFileOffset;
    }

    public static int entrySize() {
        return 24;
    }

    public int getLogSize() {
        return FileHeader.entrySize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.time.getTime());
        LogUtils.writeUnsignedInt(logBuffer, this.fileNum);
        LogUtils.writeLong(logBuffer, this.lastEntryInPrevFileOffset);
        LogUtils.writeInt(logBuffer, this.logVersion);
    }

    public void readFromLog(ByteBuffer logBuffer, byte entryVersion) throws LogException {
        this.time = LogUtils.readTimestamp(logBuffer, true);
        this.fileNum = LogUtils.readUnsignedInt(logBuffer);
        this.lastEntryInPrevFileOffset = LogUtils.readLong(logBuffer);
        this.logVersion = LogUtils.readInt(logBuffer);
        if (this.logVersion > 6) {
            throw new LogException("Expected log version 6 or earlier but found " + this.logVersion + " -- this version is not supported.");
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<FileHeader num=\"0x");
        sb.append(Long.toHexString(this.fileNum));
        sb.append("\" lastEntryInPrevFileOffset=\"0x");
        sb.append(Long.toHexString(this.lastEntryInPrevFileOffset));
        sb.append("\" logVersion=\"0x");
        sb.append(Integer.toHexString(this.logVersion));
        sb.append("\" time=\"").append(this.time);
        sb.append("\"/>");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.dumpLog(sb, true);
        return sb.toString();
    }
}

