/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.latch.LatchSupport;
import java.util.concurrent.locks.ReentrantLock;

public class Latch {
    private JEReentrantLock lock;
    private String name;
    private LatchStats stats = new LatchStats();

    public Latch(String name) {
        this.lock = new JEReentrantLock(EnvironmentImpl.getFairLatches());
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws DatabaseException {
        try {
            if (this.lock.isHeldByCurrentThread()) {
                ++this.stats.nAcquiresSelfOwned;
                throw new LatchException(this.name + " already held");
            }
            if (this.lock.isLocked()) {
                ++this.stats.nAcquiresWithContention;
            } else {
                ++this.stats.nAcquiresNoWaiters;
            }
            this.lock.lock();
            assert (this.noteLatch());
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            assert (EnvironmentImpl.maybeForceYield());
            throw throwable;
        }
        assert (EnvironmentImpl.maybeForceYield());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireNoWait() throws LatchException {
        boolean bl;
        try {
            if (this.lock.isHeldByCurrentThread()) {
                ++this.stats.nAcquiresSelfOwned;
                throw new LatchException(this.name + " already held");
            }
            boolean ret = this.lock.tryLock();
            if (ret) {
                assert (this.noteLatch());
                ++this.stats.nAcquireNoWaitSuccessful;
            } else {
                ++this.stats.nAcquireNoWaitUnsuccessful;
            }
            bl = ret;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            assert (EnvironmentImpl.maybeForceYield());
            throw throwable;
        }
        assert (EnvironmentImpl.maybeForceYield());
        return bl;
    }

    public void releaseIfOwner() {
        this.doRelease(false);
    }

    public void release() throws LatchNotHeldException {
        if (this.doRelease(true)) {
            throw new LatchNotHeldException(this.name + " not held");
        }
    }

    private boolean doRelease(boolean checkHeld) {
        try {
            if (!this.lock.isHeldByCurrentThread()) {
                return true;
            }
            this.lock.unlock();
            ++this.stats.nReleases;
            assert (this.unNoteLatch(checkHeld));
        }
        catch (IllegalMonitorStateException IMSE) {
            return true;
        }
        return false;
    }

    public LatchStats getLatchStats() {
        LatchStats s = null;
        try {
            s = (LatchStats)this.stats.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return s;
    }

    public String toString() {
        return this.lock.toString();
    }

    private boolean noteLatch() throws LatchException {
        return LatchSupport.latchTable.noteLatch(this);
    }

    private boolean unNoteLatch(boolean checkHeld) {
        if (checkHeld) {
            return LatchSupport.latchTable.unNoteLatch(this, this.name);
        }
        LatchSupport.latchTable.unNoteLatch(this, this.name);
        return true;
    }

    private static class JEReentrantLock
    extends ReentrantLock {
        JEReentrantLock(boolean fair) {
            super(fair);
        }

        protected Thread getOwner() {
            return super.getOwner();
        }
    }
}

