/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.latch.LatchStats;
import java.io.Serializable;

public class LockStats
implements Serializable {
    private int nTotalLocks;
    private int nReadLocks;
    private int nWriteLocks;
    private int nWaiters;
    private int nOwners;
    private long nRequests;
    private long nWaits;
    private LatchStats lockTableLatchStats;

    public int getNOwners() {
        return this.nOwners;
    }

    public int getNReadLocks() {
        return this.nReadLocks;
    }

    public int getNTotalLocks() {
        return this.nTotalLocks;
    }

    public int getNWaiters() {
        return this.nWaiters;
    }

    public int getNWriteLocks() {
        return this.nWriteLocks;
    }

    public void setNOwners(int val) {
        this.nOwners = val;
    }

    public void setNReadLocks(int val) {
        this.nReadLocks = val;
    }

    public void accumulateNTotalLocks(int val) {
        this.nTotalLocks += val;
    }

    public void setNWaiters(int val) {
        this.nWaiters = val;
    }

    public void setNWriteLocks(int val) {
        this.nWriteLocks = val;
    }

    public void setNRequests(long requests) {
        this.nRequests = requests;
    }

    public void setNWaits(long waits) {
        this.nWaits = waits;
    }

    public void accumulateLockTableLatchStats(LatchStats latchStats) {
        if (this.lockTableLatchStats == null) {
            this.lockTableLatchStats = latchStats;
            return;
        }
        this.lockTableLatchStats.nAcquiresNoWaiters += latchStats.nAcquiresNoWaiters;
        this.lockTableLatchStats.nAcquiresSelfOwned += latchStats.nAcquiresSelfOwned;
        this.lockTableLatchStats.nAcquiresUpgrade += latchStats.nAcquiresUpgrade;
        this.lockTableLatchStats.nAcquiresWithContention += latchStats.nAcquiresWithContention;
        this.lockTableLatchStats.nAcquireNoWaitSuccessful += latchStats.nAcquireNoWaitSuccessful;
        this.lockTableLatchStats.nAcquireNoWaitUnsuccessful += latchStats.nAcquireNoWaitUnsuccessful;
        this.lockTableLatchStats.nAcquireSharedSuccessful += latchStats.nAcquireSharedSuccessful;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nFast mode stats (always available)\n");
        sb.append("nRequests=").append(this.nRequests).append('\n');
        sb.append("nWaits=").append(this.nWaits).append('\n');
        sb.append("\nSlow mode stats (not available in fast mode)\n");
        sb.append("nTotalLocks=").append(this.nTotalLocks).append('\n');
        sb.append("nReadLocks=").append(this.nReadLocks).append('\n');
        sb.append("nWriteLocks=").append(this.nWriteLocks).append('\n');
        sb.append("nWaiters=").append(this.nWaiters).append('\n');
        sb.append("nOwners=").append(this.nOwners).append('\n');
        sb.append("lockTableLatch:\n").append(this.lockTableLatchStats);
        return sb.toString();
    }
}

