/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;

public class EnvironmentConfig
extends EnvironmentMutableConfig {
    public static final EnvironmentConfig DEFAULT = new EnvironmentConfig();
    private boolean createUP = true;
    private boolean checkpointUP = true;
    private boolean allowCreate = false;
    private boolean txnReadCommitted = false;

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setTransactional(boolean transactional) {
        DbConfigManager.setVal(this.props, EnvironmentParams.ENV_INIT_TXN, Boolean.toString(transactional), this.validateParams);
    }

    public boolean getTransactional() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.ENV_INIT_TXN);
        return Boolean.valueOf(val);
    }

    public void setLocking(boolean locking) {
        DbConfigManager.setVal(this.props, EnvironmentParams.ENV_INIT_LOCKING, Boolean.toString(locking), this.validateParams);
    }

    public boolean getLocking() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.ENV_INIT_LOCKING);
        return Boolean.valueOf(val);
    }

    public boolean getTxnSerializableIsolation() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.TXN_SERIALIZABLE_ISOLATION);
        return Boolean.valueOf(val);
    }

    boolean getTxnReadCommitted() {
        return this.txnReadCommitted;
    }

    public void setSharedCache(boolean sharedCache) {
        DbConfigManager.setVal(this.props, EnvironmentParams.ENV_SHARED_CACHE, Boolean.toString(sharedCache), this.validateParams);
    }

    public boolean getSharedCache() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.ENV_SHARED_CACHE);
        return Boolean.valueOf(val);
    }

    boolean getCreateUP() {
        return this.createUP;
    }

    boolean getCheckpointUP() {
        return this.checkpointUP;
    }

    EnvironmentConfig cloneConfig() {
        try {
            return (EnvironmentConfig)this.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public String toString() {
        return "allowCreate=" + this.allowCreate + "\n" + super.toString();
    }
}

