/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.Integers;
import com.sixlegs.png.PngConstants;
import com.sixlegs.png.PngException;
import com.sixlegs.png.PngImage;
import com.sixlegs.png.SuggestedPalette;
import com.sixlegs.png.SuggestedPaletteImpl;
import com.sixlegs.png.TextChunkImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class RegisteredChunks {
    private static final TimeZone TIME_ZONE = TimeZone.getTimeZone("UTC");
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$List;

    public static boolean read(int type, DataInput in, int length, PngImage png) throws IOException {
        Map props = png.getProperties();
        switch (type) {
            case 1229472850: {
                RegisteredChunks.read_IHDR(in, length, props);
                break;
            }
            case 1229278788: {
                RegisteredChunks.checkLength(1229278788, length, 0);
                break;
            }
            case 1347179589: {
                RegisteredChunks.read_PLTE(in, length, props, png);
                break;
            }
            case 1649100612: {
                RegisteredChunks.read_bKGD(in, length, props, png);
                break;
            }
            case 1951551059: {
                RegisteredChunks.read_tRNS(in, length, props, png);
                break;
            }
            case 1933723988: {
                RegisteredChunks.read_sBIT(in, length, props, png);
                break;
            }
            case 1749635924: {
                RegisteredChunks.read_hIST(in, length, props, png);
                break;
            }
            case 1934642260: {
                RegisteredChunks.read_sPLT(in, length, props, png);
                break;
            }
            case 1665684045: {
                RegisteredChunks.read_cHRM(in, length, props);
                break;
            }
            case 1732332865: {
                RegisteredChunks.read_gAMA(in, length, props);
                break;
            }
            case 1766015824: {
                RegisteredChunks.read_iCCP(in, length, props);
                break;
            }
            case 1883789683: {
                RegisteredChunks.read_pHYs(in, length, props);
                break;
            }
            case 1934772034: {
                RegisteredChunks.read_sRGB(in, length, props);
                break;
            }
            case 1950960965: {
                RegisteredChunks.read_tIME(in, length, props);
                break;
            }
            case 1732855399: {
                RegisteredChunks.read_gIFg(in, length, props);
                break;
            }
            case 1866876531: {
                RegisteredChunks.read_oFFs(in, length, props);
                break;
            }
            case 1933787468: {
                RegisteredChunks.read_sCAL(in, length, props);
                break;
            }
            case 1934902610: {
                RegisteredChunks.read_sTER(in, length, props);
                break;
            }
            case 1767135348: 
            case 1950701684: 
            case 2052348020: {
                RegisteredChunks.readText(type, in, length, props, png);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static void read_IHDR(DataInput in, int length, Map props) throws IOException {
        RegisteredChunks.checkLength(1229472850, length, 13);
        int width = in.readInt();
        int height = in.readInt();
        if (width <= 0 || height <= 0) {
            throw new PngException("Bad image size: " + width + "x" + height, true);
        }
        byte bitDepth = in.readByte();
        switch (bitDepth) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                throw new PngException("Bad bit depth: " + bitDepth, true);
            }
        }
        Object sbits = null;
        int colorType = in.readUnsignedByte();
        switch (colorType) {
            case 0: 
            case 2: {
                break;
            }
            case 3: {
                if (bitDepth != 16) break;
                throw new PngException("Bad bit depth for color type " + colorType + ": " + bitDepth, true);
            }
            case 4: 
            case 6: {
                if (bitDepth > 4) break;
                throw new PngException("Bad bit depth for color type " + colorType + ": " + bitDepth, true);
            }
            default: {
                throw new PngException("Bad color type: " + colorType, true);
            }
        }
        int compression = in.readUnsignedByte();
        if (compression != 0) {
            throw new PngException("Unrecognized compression method: " + compression, true);
        }
        int filter = in.readUnsignedByte();
        if (filter != 0) {
            throw new PngException("Unrecognized filter method: " + filter, true);
        }
        int interlace = in.readUnsignedByte();
        switch (interlace) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new PngException("Unrecognized interlace method: " + interlace, true);
            }
        }
        props.put("width", Integers.valueOf(width));
        props.put("height", Integers.valueOf(height));
        props.put("bit_depth", Integers.valueOf(bitDepth));
        props.put("interlace", Integers.valueOf(interlace));
        props.put("compression", Integers.valueOf(compression));
        props.put("filter", Integers.valueOf(filter));
        props.put("color_type", Integers.valueOf(colorType));
    }

    private static void read_PLTE(DataInput in, int length, Map props, PngImage png) throws IOException {
        if (length == 0) {
            throw new PngException("PLTE chunk cannot be empty", true);
        }
        if (length % 3 != 0) {
            throw new PngException("PLTE chunk length indivisible by 3: " + length, true);
        }
        int size = length / 3;
        if (size > 256) {
            throw new PngException("Too many palette entries: " + size, true);
        }
        switch (png.getColorType()) {
            case 3: {
                if (size <= 2 << png.getBitDepth() - 1) break;
                throw new PngException("Too many palette entries: " + size, true);
            }
            case 0: 
            case 4: {
                throw new PngException("PLTE chunk found in grayscale image", false);
            }
        }
        byte[] palette = new byte[length];
        in.readFully(palette);
        props.put("palette", palette);
    }

    private static void read_tRNS(DataInput in, int length, Map props, PngImage png) throws IOException {
        switch (png.getColorType()) {
            case 0: {
                RegisteredChunks.checkLength(1951551059, length, 2);
                props.put("transparency", new int[]{in.readUnsignedShort()});
                break;
            }
            case 2: {
                RegisteredChunks.checkLength(1951551059, length, 6);
                props.put("transparency", new int[]{in.readUnsignedShort(), in.readUnsignedShort(), in.readUnsignedShort()});
                break;
            }
            case 3: {
                int paletteSize = ((byte[])png.getProperty("palette", array$B == null ? (array$B = RegisteredChunks.class$("[B")) : array$B, true)).length / 3;
                if (length > paletteSize) {
                    throw new PngException("Too many transparency palette entries (" + length + " > " + paletteSize + ")", true);
                }
                byte[] trans = new byte[length];
                in.readFully(trans);
                props.put("palette_alpha", trans);
                break;
            }
            default: {
                throw new PngException("tRNS prohibited for color type " + png.getColorType(), true);
            }
        }
    }

    private static void read_bKGD(DataInput in, int length, Map props, PngImage png) throws IOException {
        int[] background;
        switch (png.getColorType()) {
            case 3: {
                RegisteredChunks.checkLength(1649100612, length, 1);
                background = new int[]{in.readUnsignedByte()};
                break;
            }
            case 0: 
            case 4: {
                RegisteredChunks.checkLength(1649100612, length, 2);
                background = new int[]{in.readUnsignedShort()};
                break;
            }
            default: {
                RegisteredChunks.checkLength(1649100612, length, 6);
                background = new int[]{in.readUnsignedShort(), in.readUnsignedShort(), in.readUnsignedShort()};
            }
        }
        props.put("background_rgb", background);
    }

    private static void read_cHRM(DataInput in, int length, Map props) throws IOException {
        RegisteredChunks.checkLength(1665684045, length, 32);
        float[] array = new float[8];
        for (int i = 0; i < 8; ++i) {
            array[i] = (float)in.readInt() / 100000.0f;
        }
        if (!props.containsKey("chromaticity")) {
            props.put("chromaticity", array);
        }
    }

    private static void read_gAMA(DataInput in, int length, Map props) throws IOException {
        RegisteredChunks.checkLength(1732332865, length, 4);
        int gamma = in.readInt();
        if (gamma == 0) {
            throw new PngException("Meaningless zero gAMA chunk value", false);
        }
        if (!props.containsKey("rendering_intent")) {
            props.put("gamma", new Float((float)gamma / 100000.0f));
        }
    }

    private static void read_hIST(DataInput in, int length, Map props, PngImage png) throws IOException {
        int paletteSize = ((byte[])png.getProperty("palette", array$B == null ? (array$B = RegisteredChunks.class$("[B")) : array$B, true)).length / 3;
        RegisteredChunks.checkLength(1749635924, length, paletteSize * 2);
        int[] array = new int[paletteSize];
        for (int i = 0; i < paletteSize; ++i) {
            array[i] = in.readUnsignedShort();
        }
        props.put("histogram", array);
    }

    private static void read_iCCP(DataInput in, int length, Map props) throws IOException {
        String name = RegisteredChunks.readKeyword(in, length);
        byte[] data = RegisteredChunks.readCompressed(in, length - name.length() - 1, true);
        props.put("icc_profile_name", name);
        props.put("icc_profile", data);
    }

    private static void read_pHYs(DataInput in, int length, Map props) throws IOException {
        RegisteredChunks.checkLength(1883789683, length, 9);
        int pixelsPerUnitX = in.readInt();
        int pixelsPerUnitY = in.readInt();
        int unit = in.readUnsignedByte();
        if (unit != 0 && unit != 1) {
            throw new PngException("Illegal pHYs chunk unit specifier: " + unit, false);
        }
        props.put("pixels_per_unit_x", Integers.valueOf(pixelsPerUnitX));
        props.put("pixels_per_unit_y", Integers.valueOf(pixelsPerUnitY));
        props.put("unit", Integers.valueOf(unit));
    }

    private static void read_sBIT(DataInput in, int length, Map props, PngImage png) throws IOException {
        boolean paletted = png.getColorType() == 3;
        int count = paletted ? 3 : png.getSamples();
        RegisteredChunks.checkLength(1933723988, length, count);
        int depth = paletted ? 8 : png.getBitDepth();
        byte[] array = new byte[count];
        for (int i = 0; i < count; ++i) {
            int bits = in.readByte();
            if (bits <= 0 || bits > depth) {
                throw new PngException("Illegal sBIT sample depth", false);
            }
            array[i] = bits;
        }
        props.put("significant_bits", array);
    }

    private static void read_sRGB(DataInput in, int length, Map props) throws IOException {
        RegisteredChunks.checkLength(1934772034, length, 1);
        byte intent = in.readByte();
        props.put("rendering_intent", Integers.valueOf(intent));
        props.put("gamma", new Float(0.45455));
        props.put("chromaticity", new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f});
    }

    private static void read_tIME(DataInput in, int length, Map props) throws IOException {
        RegisteredChunks.checkLength(1950960965, length, 7);
        Calendar cal = Calendar.getInstance(TIME_ZONE);
        cal.set(in.readUnsignedShort(), RegisteredChunks.check(in.readUnsignedByte(), 1, 12, "month") - 1, RegisteredChunks.check(in.readUnsignedByte(), 1, 31, "day"), RegisteredChunks.check(in.readUnsignedByte(), 0, 23, "hour"), RegisteredChunks.check(in.readUnsignedByte(), 0, 59, "minute"), RegisteredChunks.check(in.readUnsignedByte(), 0, 60, "second"));
        props.put("time", cal.getTime());
    }

    private static int check(int value, int min, int max, String field) throws PngException {
        if (value < min || value > max) {
            throw new PngException("tIME " + field + " value " + value + " is out of bounds (" + min + "-" + max + ")", false);
        }
        return value;
    }

    private static void read_sPLT(DataInput in, int length, Map props, PngImage png) throws IOException {
        String name = RegisteredChunks.readKeyword(in, length);
        byte sampleDepth = in.readByte();
        if (sampleDepth != 8 && sampleDepth != 16) {
            throw new PngException("Sample depth must be 8 or 16", false);
        }
        if ((length -= name.length() + 2) % (sampleDepth == 8 ? 6 : 10) != 0) {
            throw new PngException("Incorrect sPLT data length for given sample depth", false);
        }
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        ArrayList<SuggestedPaletteImpl> palettes = (ArrayList<SuggestedPaletteImpl>)png.getProperty("suggested_palettes", class$java$util$List == null ? (class$java$util$List = RegisteredChunks.class$("java.util.List")) : class$java$util$List, false);
        if (palettes == null) {
            palettes = new ArrayList<SuggestedPaletteImpl>();
            props.put("suggested_palettes", palettes);
        }
        Iterator it = palettes.iterator();
        while (it.hasNext()) {
            if (!name.equals(((SuggestedPalette)it.next()).getName())) continue;
            throw new PngException("Duplicate suggested palette name " + name, false);
        }
        palettes.add(new SuggestedPaletteImpl(name, sampleDepth, bytes));
    }

    private static void readText(int type, DataInput in, int length, Map props, PngImage png) throws IOException {
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        String keyword = RegisteredChunks.readKeyword(data, length);
        String enc = "ISO-8859-1";
        boolean compressed = false;
        boolean readMethod = true;
        String language = null;
        String translated = null;
        switch (type) {
            case 1950701684: {
                break;
            }
            case 2052348020: {
                compressed = true;
                break;
            }
            case 1767135348: {
                enc = "UTF-8";
                byte flag = data.readByte();
                byte method = data.readByte();
                if (flag == 1) {
                    compressed = true;
                    readMethod = false;
                    if (method != 0) {
                        throw new PngException("Unrecognized " + PngConstants.getChunkName(type) + " compression method: " + method, false);
                    }
                } else if (flag != 0) {
                    throw new PngException("Illegal " + PngConstants.getChunkName(type) + " compression flag: " + flag, false);
                }
                language = RegisteredChunks.readString(data, data.available(), "US-ASCII");
                translated = RegisteredChunks.readString(data, data.available(), "UTF-8");
            }
        }
        String text = compressed ? new String(RegisteredChunks.readCompressed(data, data.available(), readMethod), enc) : new String(bytes, bytes.length - data.available(), data.available(), enc);
        if (text.indexOf(0) >= 0) {
            throw new PngException("Text value contains null", false);
        }
        ArrayList<TextChunkImpl> chunks = (ArrayList<TextChunkImpl>)png.getProperty("text_chunks", class$java$util$List == null ? (class$java$util$List = RegisteredChunks.class$("java.util.List")) : class$java$util$List, false);
        if (chunks == null) {
            chunks = new ArrayList<TextChunkImpl>();
            props.put("text_chunks", chunks);
        }
        chunks.add(new TextChunkImpl(keyword, text, language, translated, type));
    }

    private static void read_gIFg(DataInput in, int length, Map props) throws IOException {
        RegisteredChunks.checkLength(1732855399, length, 4);
        int disposalMethod = in.readUnsignedByte();
        int userInputFlag = in.readUnsignedByte();
        int delayTime = in.readUnsignedShort();
        props.put("gif_disposal_method", Integers.valueOf(disposalMethod));
        props.put("gif_user_input_flag", Integers.valueOf(userInputFlag));
        props.put("gif_delay_time", Integers.valueOf(delayTime));
    }

    private static void read_oFFs(DataInput in, int length, Map props) throws IOException {
        RegisteredChunks.checkLength(1866876531, length, 9);
        int x = in.readInt();
        int y = in.readInt();
        byte unit = in.readByte();
        if (unit != 0 && unit != 1) {
            throw new PngException("Illegal oFFs chunk unit specifier: " + unit, false);
        }
        props.put("position_x", Integers.valueOf(x));
        props.put("position_y", Integers.valueOf(y));
        props.put("position_unit", Integers.valueOf(unit));
    }

    private static void read_sCAL(DataInput in, int length, Map props) throws IOException {
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        byte unit = data.readByte();
        if (unit != 1 && unit != 2) {
            throw new PngException("Illegal sCAL chunk unit specifier: " + unit, false);
        }
        double width = RegisteredChunks.readFloatingPoint(data, data.available());
        double height = RegisteredChunks.readFloatingPoint(data, data.available());
        if (width <= 0.0 || height <= 0.0) {
            throw new PngException("sCAL measurements must be >= 0", false);
        }
        props.put("scale_unit", Integers.valueOf(unit));
        props.put("pixel_width", new Double(width));
        props.put("pixel_height", new Double(height));
    }

    private static void read_sTER(DataInput in, int length, Map props) throws IOException {
        RegisteredChunks.checkLength(1934902610, length, 1);
        byte mode = in.readByte();
        switch (mode) {
            case 0: 
            case 1: {
                props.put("stereo_mode", Integers.valueOf(mode));
                break;
            }
            default: {
                throw new PngException("Unknown sTER mode: " + mode, false);
            }
        }
    }

    public static void checkLength(int chunk, int length, int correct) throws PngException {
        if (length != correct) {
            throw new PngException("Bad " + PngConstants.getChunkName(chunk) + " chunk length: " + length + " (expected " + correct + ")", true);
        }
    }

    private static byte[] readCompressed(DataInput in, int length, boolean readMethod) throws IOException {
        if (readMethod) {
            byte method = in.readByte();
            if (method != 0) {
                throw new PngException("Unrecognized compression method: " + method, false);
            }
            --length;
        }
        byte[] data = new byte[length];
        in.readFully(data);
        byte[] tmp = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Inflater inf = new Inflater();
        inf.reset();
        inf.setInput(data, 0, length);
        try {
            while (!inf.needsInput()) {
                out.write(tmp, 0, inf.inflate(tmp));
            }
        }
        catch (DataFormatException e) {
            throw new PngException("Error reading compressed data", e, false);
        }
        return out.toByteArray();
    }

    private static String readString(DataInput in, int limit, String enc) throws IOException {
        return new String(RegisteredChunks.readToNull(in, limit), enc);
    }

    private static String readKeyword(DataInput in, int limit) throws IOException {
        String keyword = RegisteredChunks.readString(in, limit, "ISO-8859-1");
        if (keyword.length() == 0 || keyword.length() > 79) {
            throw new PngException("Invalid keyword length: " + keyword.length(), false);
        }
        return keyword;
    }

    private static byte[] readToNull(DataInput in, int limit) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < limit; ++i) {
            int c = in.readUnsignedByte();
            if (c == 0) {
                return out.toByteArray();
            }
            out.write(c);
        }
        return out.toByteArray();
    }

    private static double readFloatingPoint(DataInput in, int limit) throws IOException {
        String s;
        int e = Math.max((s = RegisteredChunks.readString(in, limit, "US-ASCII")).indexOf(101), s.indexOf(69));
        double d = Double.valueOf(s.substring(0, e < 0 ? s.length() : e));
        if (e >= 0) {
            d *= Math.pow(10.0, Double.valueOf(s.substring(e + 1)));
        }
        return d;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

