/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.internal;

import com.itextpdf.text.DocWriter;
import com.itextpdf.text.pdf.OutputStreamCounter;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;

public class PdfVersionImp {
    public static final byte[][] HEADER = new byte[][]{DocWriter.getISOBytes("\n"), DocWriter.getISOBytes("%PDF-"), DocWriter.getISOBytes("\n%\u00e2\u00e3\u00cf\u00d3\n")};
    protected boolean headerWasWritten = false;
    protected boolean appendmode = false;
    protected char header_version = (char)52;
    protected PdfName catalog_version = null;
    protected PdfDictionary extensions = null;

    public void writeHeader(OutputStreamCounter os) throws IOException {
        if (this.appendmode) {
            os.write(HEADER[0]);
        } else {
            os.write(HEADER[1]);
            os.write(this.getVersionAsByteArray(this.header_version));
            os.write(HEADER[2]);
            this.headerWasWritten = true;
        }
    }

    public PdfName getVersionAsName(char version) {
        switch (version) {
            case '2': {
                return PdfWriter.PDF_VERSION_1_2;
            }
            case '3': {
                return PdfWriter.PDF_VERSION_1_3;
            }
            case '4': {
                return PdfWriter.PDF_VERSION_1_4;
            }
            case '5': {
                return PdfWriter.PDF_VERSION_1_5;
            }
            case '6': {
                return PdfWriter.PDF_VERSION_1_6;
            }
            case '7': {
                return PdfWriter.PDF_VERSION_1_7;
            }
        }
        return PdfWriter.PDF_VERSION_1_4;
    }

    public byte[] getVersionAsByteArray(char version) {
        return DocWriter.getISOBytes(this.getVersionAsName(version).toString().substring(1));
    }

    public void addToCatalog(PdfDictionary catalog) {
        if (this.catalog_version != null) {
            catalog.put(PdfName.VERSION, this.catalog_version);
        }
        if (this.extensions != null) {
            catalog.put(PdfName.EXTENSIONS, this.extensions);
        }
    }
}

