/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.exceptions.InvalidPdfException;
import com.itextpdf.text.exceptions.UnsupportedPdfException;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.LZWDecoder;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfEncodings;
import com.itextpdf.text.pdf.PdfEncryption;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReaderInstance;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.codec.TIFFFaxDecoder;
import com.itextpdf.text.pdf.codec.TIFFFaxDecompressor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.InflaterInputStream;

public class PdfReader {
    public static boolean unethicalreading = false;
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    static final byte[] endstream = PdfEncodings.convertToBytes("endstream", null);
    static final byte[] endobj = PdfEncodings.convertToBytes("endobj", null);
    protected PRTokeniser tokens;
    protected int[] xref;
    protected IntHashtable objStmToOffset;
    private ArrayList<PdfObject> xrefObj;
    PdfDictionary rootPages;
    protected PageRefs pageRefs;
    protected PdfEncryption decrypt;
    protected ArrayList<PdfString> strings;
    private int objNum;
    private int objGen;
    private int lastXrefPartial;
    private boolean partial;
    private boolean appendable;
    private int readDepth;

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter writer) {
        return new PdfReaderInstance(this, writer);
    }

    public static PdfObject getPdfObjectRelease(PdfObject obj) {
        PdfObject obj2 = PdfReader.getPdfObject(obj);
        PdfReader.releaseLastXrefPartial(obj);
        return obj2;
    }

    public static PdfObject getPdfObject(PdfObject obj) {
        if (obj == null) {
            return null;
        }
        if (!obj.isIndirect()) {
            return obj;
        }
        try {
            PRIndirectReference ref = (PRIndirectReference)obj;
            int idx = ref.getNumber();
            boolean appendable = ref.getReader().appendable;
            obj = ref.getReader().getPdfObject(idx);
            if (obj == null) {
                return null;
            }
            if (appendable) {
                switch (obj.type()) {
                    case 8: {
                        obj = new PdfNull();
                        break;
                    }
                    case 1: {
                        obj = new PdfBoolean(((PdfBoolean)obj).booleanValue());
                        break;
                    }
                    case 4: {
                        obj = new PdfName(obj.getBytes());
                    }
                }
                obj.setIndRef(ref);
            }
            return obj;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static PdfObject getPdfObject(PdfObject obj, PdfObject parent) {
        if (obj == null) {
            return null;
        }
        if (!obj.isIndirect()) {
            PRIndirectReference ref = null;
            if (parent != null && (ref = parent.getIndRef()) != null && ref.getReader().isAppendable()) {
                switch (obj.type()) {
                    case 8: {
                        obj = new PdfNull();
                        break;
                    }
                    case 1: {
                        obj = new PdfBoolean(((PdfBoolean)obj).booleanValue());
                        break;
                    }
                    case 4: {
                        obj = new PdfName(obj.getBytes());
                    }
                }
                obj.setIndRef(ref);
            }
            return obj;
        }
        return PdfReader.getPdfObject(obj);
    }

    public PdfObject getPdfObjectRelease(int idx) {
        PdfObject obj = this.getPdfObject(idx);
        this.releaseLastXrefPartial();
        return obj;
    }

    public PdfObject getPdfObject(int idx) {
        try {
            this.lastXrefPartial = -1;
            if (idx < 0 || idx >= this.xrefObj.size()) {
                return null;
            }
            PdfObject obj = this.xrefObj.get(idx);
            if (!this.partial || obj != null) {
                return obj;
            }
            if (idx * 2 >= this.xref.length) {
                return null;
            }
            obj = this.readSingleObject(idx);
            this.lastXrefPartial = -1;
            if (obj != null) {
                this.lastXrefPartial = idx;
            }
            return obj;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void releaseLastXrefPartial() {
        if (this.partial && this.lastXrefPartial != -1) {
            this.xrefObj.set(this.lastXrefPartial, null);
            this.lastXrefPartial = -1;
        }
    }

    public static void releaseLastXrefPartial(PdfObject obj) {
        if (obj == null) {
            return;
        }
        if (!obj.isIndirect()) {
            return;
        }
        if (!(obj instanceof PRIndirectReference)) {
            return;
        }
        PRIndirectReference ref = (PRIndirectReference)obj;
        PdfReader reader = ref.getReader();
        if (reader.partial && reader.lastXrefPartial != -1 && reader.lastXrefPartial == ref.getNumber()) {
            reader.xrefObj.set(reader.lastXrefPartial, null);
        }
        reader.lastXrefPartial = -1;
    }

    protected PdfObject readSingleObject(int k) throws IOException {
        PdfObject obj;
        this.strings.clear();
        int k2 = k * 2;
        int pos = this.xref[k2];
        if (pos < 0) {
            return null;
        }
        if (this.xref[k2 + 1] > 0) {
            pos = this.objStmToOffset.get(this.xref[k2 + 1]);
        }
        if (pos == 0) {
            return null;
        }
        this.tokens.seek(pos);
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != PRTokeniser.TokenType.NUMBER) {
            this.tokens.throwError(MessageLocalization.getComposedMessage("invalid.object.number", new Object[0]));
        }
        this.objNum = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != PRTokeniser.TokenType.NUMBER) {
            this.tokens.throwError(MessageLocalization.getComposedMessage("invalid.generation.number", new Object[0]));
        }
        this.objGen = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("obj")) {
            this.tokens.throwError(MessageLocalization.getComposedMessage("token.obj.expected", new Object[0]));
        }
        try {
            obj = this.readPRObject();
            for (int j = 0; j < this.strings.size(); ++j) {
                PdfString str = this.strings.get(j);
                str.decrypt(this);
            }
            if (obj.isStream()) {
                this.checkPRStreamLength((PRStream)obj);
            }
        }
        catch (Exception e) {
            obj = null;
        }
        if (this.xref[k2 + 1] > 0) {
            obj = this.readOneObjStm((PRStream)obj, this.xref[k2]);
        }
        this.xrefObj.set(k, obj);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PdfObject readOneObjStm(PRStream stream, int idx) throws IOException {
        int first = stream.getAsNumber(PdfName.FIRST).intValue();
        byte[] b = PdfReader.getStreamBytes(stream, this.tokens.getFile());
        PRTokeniser saveTokens = this.tokens;
        this.tokens = new PRTokeniser(b);
        try {
            PdfObject obj;
            int address = 0;
            boolean ok = true;
            ++idx;
            for (int k = 0; k < idx && (ok = this.tokens.nextToken()); ++k) {
                if (this.tokens.getTokenType() != PRTokeniser.TokenType.NUMBER) {
                    ok = false;
                    break;
                }
                ok = this.tokens.nextToken();
                if (!ok) break;
                if (this.tokens.getTokenType() != PRTokeniser.TokenType.NUMBER) {
                    ok = false;
                    break;
                }
                address = this.tokens.intValue() + first;
            }
            if (!ok) {
                throw new InvalidPdfException(MessageLocalization.getComposedMessage("error.reading.objstm", new Object[0]));
            }
            this.tokens.seek(address);
            this.tokens.nextToken();
            if (this.tokens.getTokenType() == PRTokeniser.TokenType.NUMBER) {
                obj = new PdfNumber(this.tokens.getStringValue());
            } else {
                this.tokens.seek(address);
                obj = this.readPRObject();
            }
            PdfObject pdfObject = obj;
            return pdfObject;
        }
        finally {
            this.tokens = saveTokens;
        }
    }

    private void checkPRStreamLength(PRStream stream) throws IOException {
        int streamLength;
        block8: {
            int fileLength = this.tokens.length();
            int start = stream.getOffset();
            boolean calc = false;
            streamLength = 0;
            PdfObject obj = PdfReader.getPdfObjectRelease(stream.get(PdfName.LENGTH));
            if (obj != null && obj.type() == 2) {
                streamLength = ((PdfNumber)obj).intValue();
                if (streamLength + start > fileLength - 20) {
                    calc = true;
                } else {
                    this.tokens.seek(start + streamLength);
                    String line = this.tokens.readString(20);
                    if (!(line.startsWith("\nendstream") || line.startsWith("\r\nendstream") || line.startsWith("\rendstream") || line.startsWith("endstream"))) {
                        calc = true;
                    }
                }
            } else {
                calc = true;
            }
            if (calc) {
                int pos;
                byte[] tline = new byte[16];
                this.tokens.seek(start);
                do {
                    pos = this.tokens.getFilePointer();
                    if (!this.tokens.readLineSegment(tline)) break block8;
                    if (!PdfReader.equalsn(tline, endstream)) continue;
                    streamLength = pos - start;
                    break block8;
                } while (!PdfReader.equalsn(tline, endobj));
                this.tokens.seek(pos - 16);
                String s = this.tokens.readString(16);
                int index = s.indexOf("endstream");
                if (index >= 0) {
                    pos = pos - 16 + index;
                }
                streamLength = pos - start;
            }
        }
        stream.setLength(streamLength);
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary dic = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == PRTokeniser.TokenType.END_DIC) break;
            if (this.tokens.getTokenType() != PRTokeniser.TokenType.NAME) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("dictionary.key.is.not.a.name", new Object[0]));
            }
            PdfName name = new PdfName(this.tokens.getStringValue(), false);
            PdfObject obj = this.readPRObject();
            int type = obj.type();
            if (-type == PRTokeniser.TokenType.END_DIC.ordinal()) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("unexpected.gt.gt", new Object[0]));
            }
            if (-type == PRTokeniser.TokenType.END_ARRAY.ordinal()) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("unexpected.close.bracket", new Object[0]));
            }
            dic.put(name, obj);
        }
        return dic;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject obj;
        int type;
        PdfArray array = new PdfArray();
        while (-(type = (obj = this.readPRObject()).type()) != PRTokeniser.TokenType.END_ARRAY.ordinal()) {
            if (-type == PRTokeniser.TokenType.END_DIC.ordinal()) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("unexpected.gt.gt", new Object[0]));
            }
            array.add(obj);
        }
        return array;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        PRTokeniser.TokenType type = this.tokens.getTokenType();
        switch (type) {
            case START_DIC: {
                boolean hasNext;
                ++this.readDepth;
                PdfDictionary dic = this.readDictionary();
                --this.readDepth;
                int pos = this.tokens.getFilePointer();
                while ((hasNext = this.tokens.nextToken()) && this.tokens.getTokenType() == PRTokeniser.TokenType.COMMENT) {
                }
                if (hasNext && this.tokens.getStringValue().equals("stream")) {
                    int ch;
                    while ((ch = this.tokens.read()) == 32 || ch == 9 || ch == 0 || ch == 12) {
                    }
                    if (ch != 10) {
                        ch = this.tokens.read();
                    }
                    if (ch != 10) {
                        this.tokens.backOnePosition(ch);
                    }
                    PRStream stream = new PRStream(this, this.tokens.getFilePointer());
                    stream.putAll(dic);
                    stream.setObjNum(this.objNum, this.objGen);
                    return stream;
                }
                this.tokens.seek(pos);
                return dic;
            }
            case START_ARRAY: {
                ++this.readDepth;
                PdfArray arr = this.readArray();
                --this.readDepth;
                return arr;
            }
            case NUMBER: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case STRING: {
                PdfString str = new PdfString(this.tokens.getStringValue(), null).setHexWriting(this.tokens.isHexString());
                str.setObjNum(this.objNum, this.objGen);
                if (this.strings != null) {
                    this.strings.add(str);
                }
                return str;
            }
            case NAME: {
                PdfName cachedName = PdfName.staticNames.get(this.tokens.getStringValue());
                if (this.readDepth > 0 && cachedName != null) {
                    return cachedName;
                }
                return new PdfName(this.tokens.getStringValue(), false);
            }
            case REF: {
                int num = this.tokens.getReference();
                PRIndirectReference ref = new PRIndirectReference(this, num, this.tokens.getGeneration());
                return ref;
            }
            case ENDOFFILE: {
                throw new IOException(MessageLocalization.getComposedMessage("unexpected.end.of.file", new Object[0]));
            }
        }
        String sv = this.tokens.getStringValue();
        if ("null".equals(sv)) {
            if (this.readDepth == 0) {
                return new PdfNull();
            }
            return PdfNull.PDFNULL;
        }
        if ("true".equals(sv)) {
            if (this.readDepth == 0) {
                return new PdfBoolean(true);
            }
            return PdfBoolean.PDFTRUE;
        }
        if ("false".equals(sv)) {
            if (this.readDepth == 0) {
                return new PdfBoolean(false);
            }
            return PdfBoolean.PDFFALSE;
        }
        return new PdfLiteral(-type.ordinal(), this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] in) {
        byte[] b = PdfReader.FlateDecode(in, true);
        if (b == null) {
            return PdfReader.FlateDecode(in, false);
        }
        return b;
    }

    public static byte[] decodePredictor(byte[] in, PdfObject dicPar) {
        if (dicPar == null || !dicPar.isDictionary()) {
            return in;
        }
        PdfDictionary dic = (PdfDictionary)dicPar;
        PdfObject obj = PdfReader.getPdfObject(dic.get(PdfName.PREDICTOR));
        if (obj == null || !obj.isNumber()) {
            return in;
        }
        int predictor = ((PdfNumber)obj).intValue();
        if (predictor < 10) {
            return in;
        }
        int width = 1;
        obj = PdfReader.getPdfObject(dic.get(PdfName.COLUMNS));
        if (obj != null && obj.isNumber()) {
            width = ((PdfNumber)obj).intValue();
        }
        int colors = 1;
        obj = PdfReader.getPdfObject(dic.get(PdfName.COLORS));
        if (obj != null && obj.isNumber()) {
            colors = ((PdfNumber)obj).intValue();
        }
        int bpc = 8;
        obj = PdfReader.getPdfObject(dic.get(PdfName.BITSPERCOMPONENT));
        if (obj != null && obj.isNumber()) {
            bpc = ((PdfNumber)obj).intValue();
        }
        DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(in));
        ByteArrayOutputStream fout = new ByteArrayOutputStream(in.length);
        int bytesPerPixel = colors * bpc / 8;
        int bytesPerRow = (colors * width * bpc + 7) / 8;
        byte[] curr = new byte[bytesPerRow];
        byte[] prior = new byte[bytesPerRow];
        while (true) {
            int filter = 0;
            try {
                filter = dataStream.read();
                if (filter < 0) {
                    return fout.toByteArray();
                }
                dataStream.readFully(curr, 0, bytesPerRow);
            }
            catch (Exception e) {
                return fout.toByteArray();
            }
            switch (filter) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int i = bytesPerPixel; i < bytesPerRow; ++i) {
                        int n = i;
                        curr[n] = (byte)(curr[n] + curr[i - bytesPerPixel]);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < bytesPerRow; ++i) {
                        int n = i;
                        curr[n] = (byte)(curr[n] + prior[i]);
                    }
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < bytesPerPixel; ++i) {
                        int n = i;
                        curr[n] = (byte)(curr[n] + prior[i] / 2);
                    }
                    for (i = bytesPerPixel; i < bytesPerRow; ++i) {
                        int n = i;
                        curr[n] = (byte)(curr[n] + ((curr[i - bytesPerPixel] & 0xFF) + (prior[i] & 0xFF)) / 2);
                    }
                    break;
                }
                case 4: {
                    int i;
                    for (i = 0; i < bytesPerPixel; ++i) {
                        int n = i;
                        curr[n] = (byte)(curr[n] + prior[i]);
                    }
                    i = bytesPerPixel;
                    while (i < bytesPerRow) {
                        int a = curr[i - bytesPerPixel] & 0xFF;
                        int b = prior[i] & 0xFF;
                        int c = prior[i - bytesPerPixel] & 0xFF;
                        int p = a + b - c;
                        int pa = Math.abs(p - a);
                        int pb = Math.abs(p - b);
                        int pc = Math.abs(p - c);
                        int ret = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
                        int n = i++;
                        curr[n] = (byte)(curr[n] + (byte)ret);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException(MessageLocalization.getComposedMessage("png.filter.unknown", new Object[0]));
                }
            }
            try {
                fout.write(curr);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            byte[] tmp = prior;
            prior = curr;
            curr = tmp;
        }
    }

    public static byte[] FlateDecode(byte[] in, boolean strict) {
        ByteArrayInputStream stream = new ByteArrayInputStream(in);
        InflaterInputStream zip = new InflaterInputStream(stream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[strict ? 4092 : 1];
        try {
            int n;
            while ((n = zip.read(b)) >= 0) {
                out.write(b, 0, n);
            }
            zip.close();
            out.close();
            return out.toByteArray();
        }
        catch (Exception e) {
            if (strict) {
                return null;
            }
            return out.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] in) {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean first = true;
        int n1 = 0;
        for (int k = 0; k < in.length && (ch = in[k] & 0xFF) != 62; ++k) {
            if (PRTokeniser.isWhitespace(ch)) continue;
            int n = PRTokeniser.getHex(ch);
            if (n == -1) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("illegal.character.in.asciihexdecode", new Object[0]));
            }
            if (first) {
                n1 = n;
            } else {
                out.write((byte)((n1 << 4) + n));
            }
            first = !first;
        }
        if (!first) {
            out.write((byte)(n1 << 4));
        }
        return out.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] in) {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int state = 0;
        int[] chn = new int[5];
        for (int k = 0; k < in.length && (ch = in[k] & 0xFF) != 126; ++k) {
            if (PRTokeniser.isWhitespace(ch)) continue;
            if (ch == 122 && state == 0) {
                out.write(0);
                out.write(0);
                out.write(0);
                out.write(0);
                continue;
            }
            if (ch < 33 || ch > 117) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("illegal.character.in.ascii85decode", new Object[0]));
            }
            chn[state] = ch - 33;
            if (++state != 5) continue;
            state = 0;
            int r = 0;
            for (int j = 0; j < 5; ++j) {
                r = r * 85 + chn[j];
            }
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
            out.write((byte)(r >> 8));
            out.write((byte)r);
        }
        int r = 0;
        if (state == 2) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + 614125 + 7225 + 85;
            out.write((byte)(r >> 24));
        } else if (state == 3) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + chn[2] * 85 * 85 + 7225 + 85;
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
        } else if (state == 4) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + chn[2] * 85 * 85 + chn[3] * 85 + 85;
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
            out.write((byte)(r >> 8));
        }
        return out.toByteArray();
    }

    public static byte[] LZWDecode(byte[] in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LZWDecoder lzw = new LZWDecoder();
        lzw.decode(in, out);
        return out.toByteArray();
    }

    public PdfDictionary getPageN(int pageNum) {
        PdfDictionary dic = this.pageRefs.getPageN(pageNum);
        if (dic == null) {
            return null;
        }
        if (this.appendable) {
            dic.setIndRef(this.pageRefs.getPageOrigRef(pageNum));
        }
        return dic;
    }

    public PdfDictionary getPageNRelease(int pageNum) {
        PdfDictionary dic = this.getPageN(pageNum);
        this.pageRefs.releasePage(pageNum);
        return dic;
    }

    public PRIndirectReference getPageOrigRef(int pageNum) {
        return this.pageRefs.getPageOrigRef(pageNum);
    }

    public byte[] getPageContent(int pageNum, RandomAccessFileOrArray file) throws IOException {
        PdfDictionary page = this.getPageNRelease(pageNum);
        if (page == null) {
            return null;
        }
        PdfObject contents = PdfReader.getPdfObjectRelease(page.get(PdfName.CONTENTS));
        if (contents == null) {
            return new byte[0];
        }
        ByteArrayOutputStream bout = null;
        if (contents.isStream()) {
            return PdfReader.getStreamBytes((PRStream)contents, file);
        }
        if (contents.isArray()) {
            PdfArray array = (PdfArray)contents;
            bout = new ByteArrayOutputStream();
            for (int k = 0; k < array.size(); ++k) {
                PdfObject item = PdfReader.getPdfObjectRelease(array.getPdfObject(k));
                if (item == null || !item.isStream()) continue;
                byte[] b = PdfReader.getStreamBytes((PRStream)item, file);
                bout.write(b);
                if (k == array.size() - 1) continue;
                bout.write(10);
            }
            return bout.toByteArray();
        }
        return new byte[0];
    }

    public static byte[] decodeBytes(byte[] b, PdfDictionary streamDictionary) throws IOException {
        PdfObject filter = PdfReader.getPdfObjectRelease(streamDictionary.get(PdfName.FILTER));
        ArrayList<Object> filters = new ArrayList<PdfObject>();
        if (filter != null) {
            if (filter.isName()) {
                filters.add(filter);
            } else if (filter.isArray()) {
                filters = ((PdfArray)filter).getArrayList();
            }
        }
        ArrayList<Object> dp = new ArrayList<PdfObject>();
        PdfObject dpo = PdfReader.getPdfObjectRelease(streamDictionary.get(PdfName.DECODEPARMS));
        if (dpo == null || !dpo.isDictionary() && !dpo.isArray()) {
            dpo = PdfReader.getPdfObjectRelease(streamDictionary.get(PdfName.DP));
        }
        if (dpo != null) {
            if (dpo.isDictionary()) {
                dp.add(dpo);
            } else if (dpo.isArray()) {
                dp = ((PdfArray)dpo).getArrayList();
            }
        }
        for (int j = 0; j < filters.size(); ++j) {
            PdfObject dicParam;
            PdfName name = (PdfName)PdfReader.getPdfObjectRelease((PdfObject)filters.get(j));
            if (PdfName.FLATEDECODE.equals(name) || PdfName.FL.equals(name)) {
                b = PdfReader.FlateDecode(b);
                dicParam = null;
                if (j >= dp.size()) continue;
                dicParam = (PdfObject)dp.get(j);
                b = PdfReader.decodePredictor(b, dicParam);
                continue;
            }
            if (PdfName.ASCIIHEXDECODE.equals(name) || PdfName.AHX.equals(name)) {
                b = PdfReader.ASCIIHexDecode(b);
                continue;
            }
            if (PdfName.ASCII85DECODE.equals(name) || PdfName.A85.equals(name)) {
                b = PdfReader.ASCII85Decode(b);
                continue;
            }
            if (PdfName.LZWDECODE.equals(name)) {
                b = PdfReader.LZWDecode(b);
                dicParam = null;
                if (j >= dp.size()) continue;
                dicParam = (PdfObject)dp.get(j);
                b = PdfReader.decodePredictor(b, dicParam);
                continue;
            }
            if (PdfName.CCITTFAXDECODE.equals(name)) {
                PdfObject objParam;
                PdfNumber wn = (PdfNumber)PdfReader.getPdfObjectRelease(streamDictionary.get(PdfName.WIDTH));
                PdfNumber hn = (PdfNumber)PdfReader.getPdfObjectRelease(streamDictionary.get(PdfName.HEIGHT));
                if (wn == null || hn == null) {
                    throw new UnsupportedPdfException(MessageLocalization.getComposedMessage("filter.ccittfaxdecode.is.only.supported.for.images", new Object[0]));
                }
                int width = wn.intValue();
                int height = hn.intValue();
                PdfDictionary param = null;
                if (j < dp.size() && (objParam = PdfReader.getPdfObjectRelease((PdfObject)dp.get(j))) != null && objParam instanceof PdfDictionary) {
                    param = (PdfDictionary)objParam;
                }
                int k = 0;
                boolean blackIs1 = false;
                boolean byteAlign = false;
                if (param != null) {
                    PdfBoolean bo;
                    PdfNumber kn = param.getAsNumber(PdfName.K);
                    if (kn != null) {
                        k = kn.intValue();
                    }
                    if ((bo = param.getAsBoolean(PdfName.BLACKIS1)) != null) {
                        blackIs1 = bo.booleanValue();
                    }
                    if ((bo = param.getAsBoolean(PdfName.ENCODEDBYTEALIGN)) != null) {
                        byteAlign = bo.booleanValue();
                    }
                }
                byte[] outBuf = new byte[(width + 7) / 8 * height];
                TIFFFaxDecompressor decoder = new TIFFFaxDecompressor();
                if (k == 0 || k > 0) {
                    int tiffT4Options = k > 0 ? 1 : 0;
                    decoder.SetOptions(1, 3, tiffT4Options |= byteAlign ? 4 : 0, 0);
                    decoder.decodeRaw(outBuf, b, width, height);
                    if (decoder.fails > 0) {
                        byte[] outBuf2 = new byte[(width + 7) / 8 * height];
                        int oldFails = decoder.fails;
                        decoder.SetOptions(1, 2, tiffT4Options, 0);
                        decoder.decodeRaw(outBuf2, b, width, height);
                        if (decoder.fails < oldFails) {
                            outBuf = outBuf2;
                        }
                    }
                } else {
                    TIFFFaxDecoder deca = new TIFFFaxDecoder(1, width, height);
                    deca.decodeT6(outBuf, b, 0, height, 0L);
                }
                if (!blackIs1) {
                    int len = outBuf.length;
                    int t = 0;
                    while (t < len) {
                        int n = t++;
                        outBuf[n] = (byte)(outBuf[n] ^ 0xFF);
                    }
                }
                b = outBuf;
                continue;
            }
            if (PdfName.CRYPT.equals(name)) continue;
            throw new UnsupportedPdfException(MessageLocalization.getComposedMessage("the.filter.1.is.not.supported", name));
        }
        return b;
    }

    public static byte[] getStreamBytes(PRStream stream, RandomAccessFileOrArray file) throws IOException {
        byte[] b = PdfReader.getStreamBytesRaw(stream, file);
        return PdfReader.decodeBytes(b, stream);
    }

    public static byte[] getStreamBytesRaw(PRStream stream, RandomAccessFileOrArray file) throws IOException {
        byte[] b;
        PdfReader reader = stream.getReader();
        if (stream.getOffset() < 0) {
            b = stream.getBytes();
        } else {
            b = new byte[stream.getLength()];
            file.seek(stream.getOffset());
            file.readFully(b);
            PdfEncryption decrypt = reader.getDecrypt();
            if (decrypt != null) {
                PdfObject filter = PdfReader.getPdfObjectRelease(stream.get(PdfName.FILTER));
                ArrayList<PdfObject> filters = new ArrayList<PdfObject>();
                if (filter != null) {
                    if (filter.isName()) {
                        filters.add(filter);
                    } else if (filter.isArray()) {
                        filters = ((PdfArray)filter).getArrayList();
                    }
                }
                boolean skip = false;
                for (int k = 0; k < filters.size(); ++k) {
                    PdfObject obj = PdfReader.getPdfObjectRelease((PdfObject)filters.get(k));
                    if (obj == null || !obj.toString().equals("/Crypt")) continue;
                    skip = true;
                    break;
                }
                if (!skip) {
                    decrypt.setHashKey(stream.getObjNum(), stream.getObjGen());
                    b = decrypt.decryptByteArray(b);
                }
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getStreamBytesRaw(PRStream stream) throws IOException {
        RandomAccessFileOrArray rf = stream.getReader().getSafeFile();
        try {
            rf.reOpen();
            byte[] byArray = PdfReader.getStreamBytesRaw(stream, rf);
            return byArray;
        }
        finally {
            try {
                rf.close();
            }
            catch (Exception exception) {}
        }
    }

    public int getXrefSize() {
        return this.xrefObj.size();
    }

    PdfEncryption getDecrypt() {
        return this.decrypt;
    }

    static boolean equalsn(byte[] a1, byte[] a2) {
        int length = a2.length;
        for (int k = 0; k < length; ++k) {
            if (a1[k] == a2[k]) continue;
            return false;
        }
        return true;
    }

    public void close() {
        if (!this.partial) {
            return;
        }
        try {
            this.tokens.close();
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    public boolean isAppendable() {
        return this.appendable;
    }

    static class PageRefs {
        private final PdfReader reader;
        private ArrayList<PRIndirectReference> refsn;
        private int sizep;
        private IntHashtable refsp;
        private int lastPageRead;
        private boolean keepPages;

        int size() {
            if (this.refsn != null) {
                return this.refsn.size();
            }
            return this.sizep;
        }

        public PdfDictionary getPageN(int pageNum) {
            PRIndirectReference ref = this.getPageOrigRef(pageNum);
            return (PdfDictionary)PdfReader.getPdfObject(ref);
        }

        public PRIndirectReference getPageOrigRef(int pageNum) {
            try {
                if (--pageNum < 0 || pageNum >= this.size()) {
                    return null;
                }
                if (this.refsn != null) {
                    return this.refsn.get(pageNum);
                }
                int n = this.refsp.get(pageNum);
                if (n == 0) {
                    PRIndirectReference ref = this.getSinglePage(pageNum);
                    this.lastPageRead = this.reader.lastXrefPartial == -1 ? -1 : pageNum;
                    this.reader.lastXrefPartial = -1;
                    this.refsp.put(pageNum, ref.getNumber());
                    if (this.keepPages) {
                        this.lastPageRead = -1;
                    }
                    return ref;
                }
                if (this.lastPageRead != pageNum) {
                    this.lastPageRead = -1;
                }
                if (this.keepPages) {
                    this.lastPageRead = -1;
                }
                return new PRIndirectReference(this.reader, n);
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }

        public void releasePage(int pageNum) {
            if (this.refsp == null) {
                return;
            }
            if (--pageNum < 0 || pageNum >= this.size()) {
                return;
            }
            if (pageNum != this.lastPageRead) {
                return;
            }
            this.lastPageRead = -1;
            this.reader.lastXrefPartial = this.refsp.get(pageNum);
            this.reader.releaseLastXrefPartial();
            this.refsp.remove(pageNum);
        }

        /*
         * Unable to fully structure code
         */
        protected PRIndirectReference getSinglePage(int n) {
            acc = new PdfDictionary();
            top = this.reader.rootPages;
            base = 0;
            while (true) lbl-1000:
            // 5 sources

            {
                for (k = 0; k < PdfReader.pageInhCandidates.length; ++k) {
                    obj = top.get(PdfReader.pageInhCandidates[k]);
                    if (obj == null) continue;
                    acc.put(PdfReader.pageInhCandidates[k], obj);
                }
                kids = (PdfArray)PdfReader.getPdfObjectRelease(top.get(PdfName.KIDS));
                it = kids.listIterator();
                while (true) {
                    if (!it.hasNext()) ** continue;
                    ref = (PRIndirectReference)it.next();
                    dic = (PdfDictionary)PdfReader.getPdfObject(ref);
                    last = PdfReader.access$300(this.reader);
                    count = PdfReader.getPdfObjectRelease(dic.get(PdfName.COUNT));
                    PdfReader.access$302(this.reader, last);
                    acn = 1;
                    if (count != null && count.type() == 2) {
                        acn = ((PdfNumber)count).intValue();
                    }
                    if (n < base + acn) {
                        if (count == null) {
                            dic.mergeDifferent(acc);
                            return ref;
                        }
                        this.reader.releaseLastXrefPartial();
                        top = dic;
                        ** continue;
                    }
                    this.reader.releaseLastXrefPartial();
                    base += acn;
                }
                break;
            }
        }
    }
}

