/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;

public class PdfDestination
extends PdfArray {
    private boolean status = false;

    public PdfDestination(int type, float parameter) {
        super(new PdfNumber(parameter));
        switch (type) {
            default: {
                this.addFirst(PdfName.FITH);
                break;
            }
            case 3: {
                this.addFirst(PdfName.FITV);
                break;
            }
            case 6: {
                this.addFirst(PdfName.FITBH);
                break;
            }
            case 7: {
                this.addFirst(PdfName.FITBV);
            }
        }
    }

    public PdfDestination(int type, float left, float top, float zoom) {
        super(PdfName.XYZ);
        if (left < 0.0f) {
            this.add(PdfNull.PDFNULL);
        } else {
            this.add(new PdfNumber(left));
        }
        if (top < 0.0f) {
            this.add(PdfNull.PDFNULL);
        } else {
            this.add(new PdfNumber(top));
        }
        this.add(new PdfNumber(zoom));
    }

    public boolean hasPage() {
        return this.status;
    }

    public boolean addPage(PdfIndirectReference page) {
        if (!this.status) {
            this.addFirst(page);
            this.status = true;
            return true;
        }
        return false;
    }
}

