/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDocument;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiColumnText
implements Element {
    private float desiredHeight;
    private float totalHeight;
    private boolean overflow;
    private float top;
    private ColumnText columnText;
    private ArrayList<ColumnDef> columnDefs = new ArrayList();
    private boolean simple = true;
    private int currentColumn = 0;
    private float nextY = -1.0f;
    private boolean columnsRightToLeft = false;
    private PdfDocument document;

    public MultiColumnText() {
        this(-1.0f);
    }

    public MultiColumnText(float height) {
        this.desiredHeight = height;
        this.top = -1.0f;
        this.columnText = new ColumnText(null);
        this.totalHeight = 0.0f;
    }

    public float write(PdfContentByte canvas, PdfDocument document, float documentY) throws DocumentException {
        this.document = document;
        this.columnText.setCanvas(canvas);
        if (this.columnDefs.isEmpty()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("multicolumntext.has.no.columns", new Object[0]));
        }
        this.overflow = false;
        float currentHeight = 0.0f;
        boolean done = false;
        try {
            while (!done) {
                if (this.top == -1.0f) {
                    this.top = document.getVerticalPosition(true);
                } else if (this.nextY == -1.0f) {
                    this.nextY = document.getVerticalPosition(true);
                }
                ColumnDef currentDef = this.columnDefs.get(this.getCurrentColumn());
                this.columnText.setYLine(this.top);
                float[] left = currentDef.resolvePositions(4);
                float[] right = currentDef.resolvePositions(8);
                if (document.isMarginMirroring() && document.getPageNumber() % 2 == 0) {
                    int i;
                    float delta = document.rightMargin() - document.left();
                    left = (float[])left.clone();
                    right = (float[])right.clone();
                    for (i = 0; i < left.length; i += 2) {
                        int n = i;
                        left[n] = left[n] - delta;
                    }
                    for (i = 0; i < right.length; i += 2) {
                        int n = i;
                        right[n] = right[n] - delta;
                    }
                }
                currentHeight = Math.max(currentHeight, this.getHeight(left, right));
                if (currentDef.isSimple()) {
                    this.columnText.setSimpleColumn(left[2], left[3], right[0], right[1]);
                } else {
                    this.columnText.setColumns(left, right);
                }
                int result = this.columnText.go();
                if ((result & 1) != 0) {
                    done = true;
                    this.top = this.columnText.getYLine();
                    continue;
                }
                if (this.shiftCurrentColumn()) {
                    this.top = this.nextY;
                    continue;
                }
                this.totalHeight += currentHeight;
                if (this.desiredHeight != -1.0f && this.totalHeight >= this.desiredHeight) {
                    this.overflow = true;
                    break;
                }
                documentY = this.nextY;
                this.newPage();
                currentHeight = 0.0f;
            }
        }
        catch (DocumentException ex) {
            ex.printStackTrace();
            throw ex;
        }
        if (this.desiredHeight == -1.0f && this.columnDefs.size() == 1) {
            currentHeight = documentY - this.columnText.getYLine();
        }
        return currentHeight;
    }

    private void newPage() throws DocumentException {
        this.resetCurrentColumn();
        if (this.desiredHeight == -1.0f) {
            this.nextY = -1.0f;
            this.top = -1.0f;
        } else {
            this.top = this.nextY;
        }
        this.totalHeight = 0.0f;
        if (this.document != null) {
            this.document.newPage();
        }
    }

    private float getHeight(float[] left, float[] right) {
        int i;
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (i = 0; i < left.length; i += 2) {
            min = Math.min(min, left[i + 1]);
            max = Math.max(max, left[i + 1]);
        }
        for (i = 0; i < right.length; i += 2) {
            min = Math.min(min, right[i + 1]);
            max = Math.max(max, right[i + 1]);
        }
        return max - min;
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return 40;
    }

    public ArrayList<Chunk> getChunks() {
        return null;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    private float getColumnBottom() {
        if (this.desiredHeight == -1.0f) {
            return this.document.bottom();
        }
        return Math.max(this.top - (this.desiredHeight - this.totalHeight), this.document.bottom());
    }

    public int getCurrentColumn() {
        if (this.columnsRightToLeft) {
            return this.columnDefs.size() - this.currentColumn - 1;
        }
        return this.currentColumn;
    }

    public void resetCurrentColumn() {
        this.currentColumn = 0;
    }

    public boolean shiftCurrentColumn() {
        if (this.currentColumn + 1 < this.columnDefs.size()) {
            ++this.currentColumn;
            return true;
        }
        return false;
    }

    private class ColumnDef {
        private float[] left;
        private float[] right;
        final /* synthetic */ MultiColumnText this$0;

        float[] resolvePositions(int side) {
            if (side == 4) {
                return this.resolvePositions(this.left);
            }
            return this.resolvePositions(this.right);
        }

        private float[] resolvePositions(float[] positions) {
            if (!this.isSimple()) {
                positions[1] = this.this$0.top;
                return positions;
            }
            if (this.this$0.top == -1.0f) {
                throw new RuntimeException("resolvePositions called with top=AUTOMATIC (-1).  Top position must be set befure lines can be resolved");
            }
            positions[1] = this.this$0.top;
            positions[3] = this.this$0.getColumnBottom();
            return positions;
        }

        private boolean isSimple() {
            return this.left.length == 4 && this.right.length == 4 && this.left[0] == this.left[2] && this.right[0] == this.right[2];
        }
    }
}

