/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import java.io.IOException;
import java.io.InputStream;

public class Utilities {
    public static Object[][] addToArray(Object[][] original, Object[] item) {
        if (original == null) {
            original = new Object[][]{item};
            return original;
        }
        Object[][] original2 = new Object[original.length + 1][];
        System.arraycopy(original, 0, original2, 0, original.length);
        original2[original.length] = item;
        return original2;
    }

    public static void skip(InputStream is, int size) throws IOException {
        long n;
        while (size > 0 && (n = is.skip(size)) > 0L) {
            size = (int)((long)size - n);
        }
    }

    public static boolean isSurrogateHigh(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    public static boolean isSurrogateLow(char c) {
        return c >= '\udc00' && c <= '\udfff';
    }

    public static boolean isSurrogatePair(String text, int idx) {
        if (idx < 0 || idx > text.length() - 2) {
            return false;
        }
        return Utilities.isSurrogateHigh(text.charAt(idx)) && Utilities.isSurrogateLow(text.charAt(idx + 1));
    }

    public static boolean isSurrogatePair(char[] text, int idx) {
        if (idx < 0 || idx > text.length - 2) {
            return false;
        }
        return Utilities.isSurrogateHigh(text[idx]) && Utilities.isSurrogateLow(text[idx + 1]);
    }

    public static int convertToUtf32(char highSurrogate, char lowSurrogate) {
        return (highSurrogate - 55296) * 1024 + lowSurrogate - 56320 + 65536;
    }

    public static int convertToUtf32(char[] text, int idx) {
        return (text[idx] - 55296) * 1024 + text[idx + 1] - 56320 + 65536;
    }

    public static int convertToUtf32(String text, int idx) {
        return (text.charAt(idx) - 55296) * 1024 + text.charAt(idx + 1) - 56320 + 65536;
    }
}

