/*
 * Decompiled with CFR 0.152.
 */
package bsh.org.objectweb.asm;

public class Type {
    public static final Type VOID_TYPE = new Type(0);
    public static final Type BOOLEAN_TYPE = new Type(1);
    public static final Type CHAR_TYPE = new Type(2);
    public static final Type BYTE_TYPE = new Type(3);
    public static final Type SHORT_TYPE = new Type(4);
    public static final Type INT_TYPE = new Type(5);
    public static final Type FLOAT_TYPE = new Type(6);
    public static final Type LONG_TYPE = new Type(7);
    public static final Type DOUBLE_TYPE = new Type(8);
    private final int sort;
    private char[] buf;
    private int off;
    private int len;

    private Type(int n) {
        this.sort = n;
        this.len = 1;
    }

    private Type(int n, char[] cArray, int n2, int n3) {
        this.sort = n;
        this.buf = cArray;
        this.off = n2;
        this.len = n3;
    }

    public static Type getType(String string) {
        return Type.getType(string.toCharArray(), 0);
    }

    public static Type getType(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_TYPE;
            }
            if (clazz == Void.TYPE) {
                return VOID_TYPE;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_TYPE;
            }
            if (clazz == Byte.TYPE) {
                return BYTE_TYPE;
            }
            if (clazz == Character.TYPE) {
                return CHAR_TYPE;
            }
            if (clazz == Short.TYPE) {
                return SHORT_TYPE;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE_TYPE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT_TYPE;
            }
            return LONG_TYPE;
        }
        return Type.getType(Type.getDescriptor(clazz));
    }

    private static Type getType(char[] cArray, int n) {
        switch (cArray[n]) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                int n2 = 1;
                while (cArray[n + n2] == '[') {
                    ++n2;
                }
                if (cArray[n + n2] == 'L') {
                    ++n2;
                    while (cArray[n + n2] != ';') {
                        ++n2;
                    }
                }
                return new Type(9, cArray, n, n2 + 1);
            }
        }
        int n3 = 1;
        while (cArray[n + n3] != ';') {
            ++n3;
        }
        return new Type(10, cArray, n, n3 + 1);
    }

    public static String getMethodDescriptor(Type type, Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n = 0;
        while (n < typeArray.length) {
            typeArray[n].getDescriptor(stringBuffer);
            ++n;
        }
        stringBuffer.append(')');
        type.getDescriptor(stringBuffer);
        return stringBuffer.toString();
    }

    private void getDescriptor(StringBuffer stringBuffer) {
        switch (this.sort) {
            case 0: {
                stringBuffer.append('V');
                return;
            }
            case 1: {
                stringBuffer.append('Z');
                return;
            }
            case 2: {
                stringBuffer.append('C');
                return;
            }
            case 3: {
                stringBuffer.append('B');
                return;
            }
            case 4: {
                stringBuffer.append('S');
                return;
            }
            case 5: {
                stringBuffer.append('I');
                return;
            }
            case 6: {
                stringBuffer.append('F');
                return;
            }
            case 7: {
                stringBuffer.append('J');
                return;
            }
            case 8: {
                stringBuffer.append('D');
                return;
            }
        }
        stringBuffer.append(this.buf, this.off, this.len);
    }

    public static String getInternalName(Class clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static String getDescriptor(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        Type.getDescriptor(stringBuffer, clazz);
        return stringBuffer.toString();
    }

    private static void getDescriptor(StringBuffer stringBuffer, Class clazz) {
        Class<?> clazz2 = clazz;
        while (true) {
            if (clazz2.isPrimitive()) {
                int n = clazz2 == Integer.TYPE ? 73 : (clazz2 == Void.TYPE ? 86 : (clazz2 == Boolean.TYPE ? 90 : (clazz2 == Byte.TYPE ? 66 : (clazz2 == Character.TYPE ? 67 : (clazz2 == Short.TYPE ? 83 : (clazz2 == Double.TYPE ? 68 : (clazz2 == Float.TYPE ? 70 : 74)))))));
                stringBuffer.append((char)n);
                return;
            }
            if (!clazz2.isArray()) break;
            stringBuffer.append('[');
            clazz2 = clazz2.getComponentType();
        }
        stringBuffer.append('L');
        String string = clazz2.getName();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            stringBuffer.append(c == '.' ? (char)'/' : (char)c);
            ++n2;
        }
        stringBuffer.append(';');
    }
}

